/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.huawei.bsp.encrypt.cbb;

import com.lubanops.huawei.bsp.encrypt.cbb.CipherException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;

public final class CipherUtil {
    private static final char[] SIXTEEN = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final String PLAIN_ENCODING = "UTF-8";

    private CipherUtil() {
    }

    public static byte[] encodePlainText(char[] plain) {
        if (null == plain) {
            return null;
        }
        if (plain.length == 0) {
            return new byte[0];
        }
        byte[] utf8bytes = CipherUtil.convertToUTF8Bytes(plain);
        int len = utf8bytes.length;
        int addlen = len % 16 == 0 ? 0 : 16 - len % 16;
        byte[] newbyte = new byte[addlen + len];
        System.arraycopy(utf8bytes, 0, newbyte, 0, len);
        Arrays.fill(utf8bytes, (byte)0);
        return newbyte;
    }

    public static byte[] encodeNoPadding(char[] plain) {
        if (null == plain) {
            return null;
        }
        if (plain.length == 0) {
            return new byte[0];
        }
        return CipherUtil.convertToUTF8Bytes(plain);
    }

    public static char[] decodePlainText(byte[] plain) {
        int len;
        if (null == plain) {
            return null;
        }
        int plainlen = len = plain.length;
        for (int i = len - 1; i >= 0 && plain[i] == 0; --i) {
            --plainlen;
        }
        if (plainlen == 0) {
            return new char[0];
        }
        byte[] newbyte = new byte[plainlen];
        System.arraycopy(plain, 0, newbyte, 0, plainlen);
        char[] result = CipherUtil.converToUTF8Chars(newbyte);
        Arrays.fill(newbyte, (byte)0);
        return result;
    }

    public static char[] encodeEncryptedText(byte[] encrypted) {
        if (null == encrypted) {
            return null;
        }
        char[] result = new char[encrypted.length * 2];
        for (int i = 0; i < encrypted.length; ++i) {
            byte b = encrypted[i];
            int high = (0xF0 & b) >> 4;
            int low = 0xF & b;
            result[i * 2] = SIXTEEN[high];
            result[i * 2 + 1] = SIXTEEN[low];
        }
        return result;
    }

    public static byte[] decodeEncryptedText(char[] encrypted) throws CipherException {
        if (null == encrypted) {
            return null;
        }
        if (encrypted.length % 2 != 0) {
            throw new CipherException("Invalid length.");
        }
        byte[] result = new byte[encrypted.length / 2];
        int i = 0;
        int j = 0;
        while (i < encrypted.length) {
            int value1 = CipherUtil.decodeEncryptedText(encrypted[i]);
            int value2 = CipherUtil.decodeEncryptedText(encrypted[i + 1]);
            result[j] = (byte)(value1 << 4 & 0xF0 | value2);
            i += 2;
            ++j;
        }
        return result;
    }

    private static int decodeEncryptedText(char c) throws CipherException {
        for (int i = 0; i < SIXTEEN.length; ++i) {
            if (SIXTEEN[i] != c) continue;
            return i;
        }
        throw new CipherException("Invalid char.");
    }

    private static byte[] convertToUTF8Bytes(char[] target) {
        Charset charset = Charset.forName(PLAIN_ENCODING);
        CharBuffer charBuffer = CharBuffer.allocate(target.length);
        charBuffer.put(target);
        ((Buffer)charBuffer).flip();
        ByteBuffer byteBuffer = charset.encode(charBuffer);
        byte[] bytearr = byteBuffer.array();
        int vailddataLen = bytearr.length;
        for (int i = bytearr.length - 1; i >= 0 && bytearr[i] == 0; --i) {
            --vailddataLen;
        }
        byte[] vaildDataByteArr = new byte[vailddataLen];
        System.arraycopy(bytearr, 0, vaildDataByteArr, 0, vailddataLen);
        Arrays.fill(bytearr, (byte)0);
        char[] newchar = new char[target.length];
        Arrays.fill(newchar, '\u0000');
        charBuffer.clear();
        charBuffer.put(newchar);
        return vaildDataByteArr;
    }

    private static char[] converToUTF8Chars(byte[] source) {
        Charset charset = Charset.forName(PLAIN_ENCODING);
        ByteBuffer byteBuffer = ByteBuffer.allocate(source.length);
        byteBuffer.put(source);
        ((Buffer)byteBuffer).flip();
        CharBuffer charBuffer = charset.decode(byteBuffer);
        char[] cbarr = charBuffer.array();
        int vailddataLen = cbarr.length;
        for (int i = cbarr.length - 1; i >= 0 && cbarr[i] == '\u0000'; --i) {
            --vailddataLen;
        }
        char[] vaildDataCharArr = new char[vailddataLen];
        System.arraycopy(cbarr, 0, vaildDataCharArr, 0, vailddataLen);
        Arrays.fill(cbarr, '\u0000');
        byte[] newbytes = new byte[source.length];
        Arrays.fill(source, (byte)0);
        byteBuffer.clear();
        byteBuffer.put(newbytes);
        return vaildDataCharArr;
    }
}

