/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.core.transfer;

import com.lubanops.apm.bootstrap.config.AgentConfigManager;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.log.Logger;
import com.lubanops.apm.bootstrap.utils.StringUtils;
import com.lubanops.apm.core.common.ConnectionException;
import com.lubanops.apm.core.transfer.InvokerService;
import com.lubanops.apm.core.utils.ListUtil;
import com.lubanops.apm.integration.access.Address;
import com.lubanops.apm.integration.access.MessageWrapper;
import com.lubanops.apm.integration.enums.AddressScope;
import com.lubanops.apm.integration.enums.Protocol;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class OtelTransferInvokerService
implements InvokerService {
    private static final Logger LOG = LogFactory.getLogger();
    private List<Address> innerAddressList = new ArrayList<Address>();
    private List<Address> outerAddressList = new ArrayList<Address>();
    private volatile boolean needReconnect = false;
    private static volatile OtelTransferInvokerService instance;

    public static synchronized OtelTransferInvokerService getInstance() {
        if (instance == null) {
            instance = new OtelTransferInvokerService();
        }
        return instance;
    }

    @Override
    public void setAccessAddressList(List<Address> accessAddressList, boolean isNeedConnect) {
        String configAddress = AgentConfigManager.getAccessAddress();
        if (!StringUtils.isBlank((String)configAddress)) {
            accessAddressList = this.getAddressListFromConfig(configAddress, accessAddressList);
        }
        ArrayList<Address> tmpInnerAddressList = new ArrayList<Address>();
        ArrayList<Address> tmpOuterAddressList = new ArrayList<Address>();
        for (Address address : accessAddressList) {
            if (AddressScope.inner.equals((Object)address.getScope())) {
                tmpInnerAddressList.add(address);
                continue;
            }
            if (!AddressScope.outer.equals((Object)address.getScope())) continue;
            tmpOuterAddressList.add(address);
        }
        if (!ListUtil.isEqualList(this.innerAddressList, tmpInnerAddressList)) {
            this.innerAddressList = tmpInnerAddressList;
            isNeedConnect = true;
        }
        if (!ListUtil.isEqualList(this.outerAddressList, tmpOuterAddressList)) {
            this.outerAddressList = tmpOuterAddressList;
            isNeedConnect = true;
        }
        this.needReconnect = isNeedConnect;
    }

    private List<Address> getAddressListFromConfig(String configAddress, List<Address> accessAddressList) {
        ArrayList<Address> result = new ArrayList<Address>();
        try {
            String[] addressArgs;
            for (String addressArg : addressArgs = configAddress.split(",")) {
                Address address = new Address();
                String[] addr = addressArg.split(":");
                address.setHost(addr[0]);
                int port = Integer.valueOf(addr[1]);
                address.setPort(port);
                address.setSport(port);
                address.setProtocol(Protocol.WS);
                address.setScope(AddressScope.inner);
                result.add(address);
            }
            return result;
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "apm.config accessAddress format error", (Throwable)e);
            return accessAddressList;
        }
    }

    @Override
    public void sendDataReport(MessageWrapper message) throws ConnectionException, IOException {
    }

    @Override
    public boolean isSendEnable() {
        return false;
    }

    @Override
    public boolean isTraceSendEnable(int queueUpperThreshold) {
        return false;
    }

    @Override
    public void setNeedConnect(boolean needConnect) {
        this.needReconnect = needConnect;
    }
}

