/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.core.trace;

import com.lubanops.apm.bootstrap.config.ConfigManager;
import com.lubanops.apm.bootstrap.config.IdentityConfigManager;
import com.lubanops.apm.bootstrap.trace.Headers;
import com.lubanops.apm.bootstrap.trace.OtelProtocolConfig;
import com.lubanops.apm.bootstrap.trace.OtelTraceReportService;
import io.opentelemetry.api.baggage.propagation.W3CBaggagePropagator;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.TraceFlags;
import io.opentelemetry.api.trace.TraceState;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporter;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.export.BatchSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import io.opentelemetry.semconv.resource.attributes.ResourceAttributes;
import java.util.HashMap;
import java.util.Map;

public class OtelTraceReportServiceImpl
implements OtelTraceReportService {
    private static volatile OtelTraceReportServiceImpl INSTANCE = new OtelTraceReportServiceImpl();
    private Tracer tracer;
    private OpenTelemetrySdk openTelemetrySdk;

    public static OtelTraceReportServiceImpl getInstance() {
        return INSTANCE;
    }

    public Tracer getTracer() {
        return this.tracer;
    }

    public Span creatSpan(String spanName) {
        if (!ConfigManager.isOtelCollectorEnable()) {
            return null;
        }
        return this.tracer.spanBuilder(spanName).startSpan();
    }

    public Span creatSpan(String spanName, String spanKind) {
        if (!ConfigManager.isOtelCollectorEnable()) {
            return null;
        }
        return this.tracer.spanBuilder(spanName).setSpanKind(SpanKind.valueOf((String)spanKind)).startSpan();
    }

    public Span creatSpan(String spanName, String spanKind, Span parentSpan) {
        if (!ConfigManager.isOtelCollectorEnable()) {
            return null;
        }
        if (parentSpan != null) {
            Context context = Context.current().with((ImplicitContextKeyed)parentSpan);
            return this.tracer.spanBuilder(spanName).setParent(context).setSpanKind(SpanKind.valueOf((String)spanKind)).startSpan();
        }
        return this.creatSpan(spanName, spanKind);
    }

    public Span creatSpan(String spanName, String spanKind, String otelTraceId, String parentSpanId) {
        if (!ConfigManager.isOtelCollectorEnable()) {
            return null;
        }
        if (otelTraceId == null) {
            return null;
        }
        SpanContext spanContext = SpanContext.create((String)otelTraceId, (String)parentSpanId, (TraceFlags)TraceFlags.getSampled(), (TraceState)TraceState.getDefault());
        Context context = Context.current().with((ImplicitContextKeyed)Span.wrap((SpanContext)spanContext));
        return this.tracer.spanBuilder(spanName).setParent(context).setSpanKind(SpanKind.valueOf((String)spanKind)).startSpan();
    }

    public Span creatSpan(String spanName, String spanKind, Map<String, String> carrier) {
        if (!ConfigManager.isOtelCollectorEnable()) {
            return null;
        }
        if (carrier != null && !carrier.isEmpty()) {
            Context context = this.extractParentSpan(carrier);
            return this.tracer.spanBuilder(spanName).setParent(context).setSpanKind(SpanKind.valueOf((String)spanKind)).startSpan();
        }
        return this.tracer.spanBuilder(spanName).setSpanKind(SpanKind.valueOf((String)spanKind)).startSpan();
    }

    public Span creatSpan(String spanName, String spanKind, String traceParent) {
        HashMap<String, String> carrier = new HashMap<String, String>();
        if (traceParent != null) {
            carrier.put(Headers.OTEL_HEADER.getValue(), traceParent);
        }
        return this.creatSpan(spanName, spanKind, carrier);
    }

    public void sendSpan(Span span) {
        if (span == null || !ConfigManager.isOtelCollectorEnable()) {
            return;
        }
        span.end();
    }

    public void sendSpan(Span span, Boolean hasError) {
        if (span == null || !ConfigManager.isOtelCollectorEnable()) {
            return;
        }
        if (hasError != null && hasError.booleanValue()) {
            span.setStatus(StatusCode.ERROR);
        } else {
            span.setStatus(StatusCode.OK);
        }
        span.end();
    }

    public void setAttribute(Span span, String key, Object obj) {
        if (span == null) {
            return;
        }
        if (!ConfigManager.isOtelCollectorEnable()) {
            return;
        }
        if (obj instanceof Integer) {
            span.setAttribute(key, (long)((Integer)obj).intValue());
        }
        if (obj instanceof String) {
            span.setAttribute(key, (String)obj);
        }
        if (obj instanceof Long) {
            span.setAttribute(key, ((Long)obj).longValue());
        }
        if (obj instanceof Boolean) {
            span.setAttribute(key, ((Boolean)obj).booleanValue());
        }
        if (obj instanceof Double) {
            span.setAttribute(key, ((Double)obj).doubleValue());
        }
    }

    public Context extractParentSpan(Map<String, String> carrier) {
        if (!ConfigManager.isOtelCollectorEnable()) {
            return null;
        }
        TextMapGetter<Map<String, String>> getter = new TextMapGetter<Map<String, String>>(){

            public Iterable<String> keys(Map<String, String> carrier) {
                return carrier.keySet();
            }

            public String get(Map<String, String> carrier, String key) {
                return carrier.get(key);
            }
        };
        Context extractedContext = this.openTelemetrySdk.getPropagators().getTextMapPropagator().extract(Context.current(), carrier, (TextMapGetter)getter);
        return extractedContext;
    }

    public void injectParentSpan(Map<String, String> headers, Span span) {
        if (span == null) {
            return;
        }
        Context context = Context.current().with((ImplicitContextKeyed)span);
        TextMapSetter setter = (carrier, key, value) -> carrier.put(key, value);
        this.openTelemetrySdk.getPropagators().getTextMapPropagator().inject(context, headers, setter);
    }

    public void buildTracer(OtelProtocolConfig otelProtocolConfig) {
        OtlpGrpcSpanExporter exporter = OtlpGrpcSpanExporter.builder().setEndpoint(otelProtocolConfig.getEndpoint()).setHeaders(() -> otelProtocolConfig.getHeaderMap()).build();
        BatchSpanProcessor processor = BatchSpanProcessor.builder((SpanExporter)exporter).build();
        Resource resource = Resource.getDefault().merge(Resource.create((Attributes)Attributes.of((AttributeKey)ResourceAttributes.SERVICE_NAME, (Object)otelProtocolConfig.getServiceName(), (AttributeKey)ResourceAttributes.TELEMETRY_SDK_LANGUAGE, (Object)"java", (AttributeKey)ResourceAttributes.HOST_NAME, (Object)IdentityConfigManager.getHostName())));
        SdkTracerProvider tracerProvider = SdkTracerProvider.builder().addSpanProcessor((SpanProcessor)processor).setResource(resource).build();
        ContextPropagators propagators = ContextPropagators.create((TextMapPropagator)TextMapPropagator.composite((TextMapPropagator[])new TextMapPropagator[]{W3CTraceContextPropagator.getInstance(), W3CBaggagePropagator.getInstance()}));
        this.openTelemetrySdk = OpenTelemetrySdk.builder().setTracerProvider(tracerProvider).setPropagators(propagators).buildAndRegisterGlobal();
        this.tracer = this.openTelemetrySdk.getTracer("MyTracer");
    }

    public String getSpanId(Span span) {
        if (span == null) {
            return null;
        }
        return span.getSpanContext().getSpanId();
    }

    public String getTraceId(Span span) {
        if (span == null) {
            return null;
        }
        return span.getSpanContext().getTraceId();
    }
}

