/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.core.monitor;

import com.lubanops.apm.bootstrap.api.HarvestListener;
import com.lubanops.apm.bootstrap.exception.ApmRuntimeException;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.log.Logger;
import com.lubanops.apm.bootstrap.plugin.apm.APMCollector;
import com.lubanops.apm.bootstrap.utils.AgentUtils;
import com.lubanops.apm.core.api.AgentService;
import com.lubanops.apm.core.common.ConnectionException;
import com.lubanops.apm.core.executor.standalone.ServiceThread;
import com.lubanops.apm.core.monitor.MonitorReportService;
import com.lubanops.apm.core.transfer.InvokerService;
import com.lubanops.apm.core.transfer.TransferInvokerService;
import com.lubanops.apm.core.utils.ReportDataBuilder;
import com.lubanops.apm.integration.access.MessageIdGenerator;
import com.lubanops.apm.integration.access.MessageWrapper;
import com.lubanops.apm.integration.access.inbound.MonitorDataBody;
import com.lubanops.apm.integration.access.inbound.MonitorDataRequest;
import java.io.IOException;
import java.util.concurrent.ArrayBlockingQueue;

public class MonitorReportServiceImpl
extends ServiceThread
implements MonitorReportService,
AgentService {
    public static final int DEFAULT_QUEUE_SIZE = 128;
    private static final Logger LOGGER = LogFactory.getLogger();
    private int dataQueueSize = 128;
    public ArrayBlockingQueue<MonitorDataBody> collectorDataQueue = new ArrayBlockingQueue(this.dataQueueSize);
    private boolean hasException = Boolean.FALSE;
    private volatile MonitorDataRequest innerRequest = null;
    private InvokerService invokerService = TransferInvokerService.getInstance();
    private HarvestListener harvestListener;
    private volatile boolean closed = false;
    private static volatile MonitorReportServiceImpl instance;

    public MonitorReportServiceImpl() {
        super(MonitorReportServiceImpl.class.getSimpleName());
    }

    public static synchronized MonitorReportServiceImpl getInstance() {
        if (instance == null) {
            instance = new MonitorReportServiceImpl();
        }
        return instance;
    }

    @Override
    public String getServiceName() {
        return MonitorReportServiceImpl.class.getSimpleName();
    }

    @Override
    public void run() {
        LOGGER.info("[MONITOR REPORTER]reporter start.");
        while (!this.isStopped()) {
            this.doReport();
        }
        LOGGER.info("[MONITOR REPORTER]reporter stopped.");
    }

    @Override
    public void init() throws ApmRuntimeException {
        this.harvestListener = new HarvestListener<APMCollector>(){

            public void onHarvest(APMCollector collector, long time) {
                collector.traceQueueSize((long)MonitorReportServiceImpl.this.collectorDataQueue.size(), AgentUtils.getObjectSize(MonitorReportServiceImpl.this.collectorDataQueue));
            }
        };
        APMCollector.INSTANCE.listenHarvest(this.harvestListener);
        this.start();
    }

    @Override
    public void dispose() throws ApmRuntimeException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        int shutdownTimeout = 1000;
        if (shutdownTimeout > 0) {
            long start = System.currentTimeMillis();
            while (this.collectorDataQueue.isEmpty() && System.currentTimeMillis() - start < (long)shutdownTimeout) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    LOGGER.log(Level.SEVERE, e.getMessage(), (Throwable)e);
                }
            }
        }
        this.collectorDataQueue.clear();
        this.shutdown(true);
    }

    @Override
    public boolean offer(MonitorDataBody body) {
        boolean success = this.collectorDataQueue.offer(body);
        if (!success) {
            String bodyStr = body.toString();
            APMCollector.onDiscard((String)"MonitorData", (long)bodyStr.getBytes().length);
            LOGGER.warningFullQueue("data queue is full,data discarded:" + bodyStr);
        } else {
            APMCollector.onStart((String)"MonitorData", (int)this.collectorDataQueue.size());
        }
        return success;
    }

    @Override
    public void reportInnerData(MonitorDataBody body) {
        try {
            if (this.innerRequest == null) {
                this.innerRequest = new MonitorDataRequest();
                this.innerRequest.setHeader(ReportDataBuilder.buildMonitorDataHeader());
            }
            this.innerRequest.setBody(body);
            if (this.invokerService.isSendEnable()) {
                this.invokerService.sendDataReport((MessageWrapper)this.innerRequest);
            }
            this.innerRequest = null;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "failed to send data,error message:" + e.getMessage() + ",type:" + e.getClass().getName(), (Throwable)e);
            LOGGER.log(Level.SEVERE, "data:" + this.innerRequest);
        }
    }

    @Override
    public void onWaitEnd() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doReport() {
        MonitorDataRequest request = new MonitorDataRequest();
        MonitorDataBody body = null;
        long startTime = 0L;
        long length = 0L;
        try {
            body = this.collectorDataQueue.take();
            request.setHeader(ReportDataBuilder.buildMonitorDataHeader());
            request.setMessageId(MessageIdGenerator.generateMessageId());
            request.getHeader().setNeedResponse(false);
            request.setBody(body);
            startTime = System.currentTimeMillis();
            String bodyStr = request.getBodyString();
            LOGGER.log(Level.FINE, String.format("[debug mode]sending message:[%s]", request));
            length = bodyStr.getBytes().length;
            if (length > 1000000L) {
                LOGGER.log(Level.SEVERE, "data\u8fc7\u5927:" + bodyStr);
                APMCollector.onThrowable((String)"MonitorData", (long)length, (Throwable)new ApmRuntimeException("\u4e0a\u62a5\u6570\u636e\u8d85\u8fc71M"));
            }
            this.sendData(request, bodyStr, length);
        }
        catch (Throwable e) {
            if (!this.hasException) {
                LOGGER.log(Level.SEVERE, this.getServiceName() + " has exception.", e);
            } else if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, this.getServiceName() + " has exception.", e);
            }
            APMCollector.onThrowable((String)"MonitorData", (long)length, (Throwable)e);
            this.hasException = true;
        }
        finally {
            if (body != null) {
                APMCollector.onFinally((String)"MonitorData", (long)(System.currentTimeMillis() - startTime));
            }
        }
        return true;
    }

    private void sendData(MonitorDataRequest request, String bodyStr, long length) throws ConnectionException, IOException {
        if (this.invokerService.isSendEnable()) {
            this.invokerService.sendDataReport((MessageWrapper)request);
            LOGGER.log(Level.FINE, String.format("[debug mode]sending message success:[%s]", request.getMessageId()));
        } else {
            APMCollector.onDiscard((String)"MonitorData", (long)bodyStr.getBytes().length);
        }
        APMCollector.onSuccess((String)"MonitorData", (long)length);
    }
}

