/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.plugin.mqtt.collector;

import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.collector.api.MultiPrimaryKeyAggregator;
import com.lubanops.apm.bootstrap.plugin.mqtt.stats.MqttReceiveStats;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MqttClientReceiveAggregator
extends MultiPrimaryKeyAggregator<MqttReceiveStats> {
    private static final String CLIENT_ID = "clientId";
    private static final String TOPIC = "topic";

    public void parseParameters(Map<String, String> parameters) {
    }

    public void onReceivePublishMsg(String clientId, String topic, int bytesCount) {
        MqttReceiveStats stats = (MqttReceiveStats)this.getValue(new String[]{clientId, topic});
        stats.onReceiveMsg(bytesCount);
    }

    public Map<String, List<MonitorDataRow>> afterHarvest(List<MonitorDataRow> collected) {
        HashMap<String, List<MonitorDataRow>> res = new HashMap<String, List<MonitorDataRow>>();
        ArrayList<MonitorDataRow> totalRowList = new ArrayList<MonitorDataRow>();
        long totalMsgReceivedCount = 0L;
        long totalBytesReceived = 0L;
        if (collected != null && !collected.isEmpty()) {
            for (MonitorDataRow row : collected) {
                Long msgReceivedCount = (Long)row.get((Object)"msgReceivedCount");
                Long bytesReceived = (Long)row.get((Object)"bytesReceived");
                if (msgReceivedCount == null) {
                    msgReceivedCount = 0L;
                }
                if (bytesReceived == null) {
                    bytesReceived = 0L;
                }
                totalMsgReceivedCount += msgReceivedCount.longValue();
                totalBytesReceived += bytesReceived.longValue();
            }
        }
        MonitorDataRow totalRow = new MonitorDataRow();
        totalRow.put((Object)"msgReceivedCount", (Object)totalMsgReceivedCount);
        totalRow.put((Object)"bytesReceived", (Object)totalBytesReceived);
        totalRowList.add(totalRow);
        res.put("total", totalRowList);
        return res;
    }

    protected Class<MqttReceiveStats> getValueType() {
        return MqttReceiveStats.class;
    }

    protected int primaryKeyLength() {
        return 2;
    }

    protected List<String> primaryKey() {
        return Arrays.asList(CLIENT_ID, TOPIC);
    }

    public String getName() {
        return "clientReceive";
    }
}

