/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.httpclient.collector;

import com.lubanops.apm.bootstrap.TransformAccess;
import com.lubanops.apm.bootstrap.collector.api.AbstractAggregator;
import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.plugin.httpclient.collector.PoolObjectHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.pool.PoolStats;

public class ConnectionPoolAggregator
extends AbstractAggregator {
    public List<MonitorDataRow> harvest() {
        return this.getAllStatus();
    }

    public String getName() {
        return "connectionPool";
    }

    private MonitorDataRow buildRow(Object obj) {
        if (obj instanceof PoolingHttpClientConnectionManager && obj instanceof TransformAccess) {
            MonitorDataRow row = new MonitorDataRow();
            Object poolId = ((TransformAccess)obj).getLopsAttribute();
            if (poolId != null) {
                PoolStats poolStats = ((PoolingHttpClientConnectionManager)obj).getTotalStats();
                row.put((Object)"poolId", (Object)String.valueOf(poolId));
                row.put((Object)"leased", (Object)poolStats.getLeased());
                row.put((Object)"pending", (Object)poolStats.getPending());
                row.put((Object)"available", (Object)poolStats.getAvailable());
                row.put((Object)"max", (Object)poolStats.getMax());
                return row;
            }
        }
        return null;
    }

    public MonitorDataRow getStatus(Map<String, String> primaryKeyMap) {
        String key = primaryKeyMap.get("poolId");
        if (key == null) {
            return null;
        }
        CopyOnWriteArrayList poolList = PoolObjectHolder.getPoolList();
        for (Object o : poolList) {
            MonitorDataRow row = this.buildRow(o);
            if (row == null || !key.equals(row.get((Object)"poolId"))) continue;
            return row;
        }
        return null;
    }

    public List<MonitorDataRow> getAllStatus() {
        ArrayList<MonitorDataRow> result = new ArrayList<MonitorDataRow>();
        CopyOnWriteArrayList poolList = PoolObjectHolder.getPoolList();
        for (Object o : poolList) {
            MonitorDataRow row = this.buildRow(o);
            if (row == null) continue;
            result.add(row);
        }
        return result;
    }
}

