/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.druid.interceptor;

import com.alibaba.druid.pool.DruidDataSource;
import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.plugin.connectionpool.ConnectionPoolUtils;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.bootstrap.utils.Util;
import com.lubanops.apm.plugin.druid.collector.DruidCollector;
import java.security.ProtectionDomain;

public class GetConnectionInterceptor
implements Interceptor {
    private static final String DRUID_BEFORE_GET_CONNECTION = "beforeGetConnection";
    private static final String DRUID_AFTER_GET_CONNECTION = "AfterGetConnection";
    private static final String ACTIVE_COUNT = "activeCount";
    private static final String POOLING_COUNT = "poolingCount";
    private static final String WAIT_THREAD_COUNT = "waitThreadCount";

    public GetConnectionInterceptor() {
        DruidCollector.setDriverVersion(Util.getJarVersionFromProtectionDomain((ProtectionDomain)DruidDataSource.class.getProtectionDomain()));
    }

    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            if (DruidCollector.INSTANCE.isEnable()) {
                DruidDataSource dataSource = (DruidDataSource)object;
                int activeCount = dataSource.getActiveCount();
                int poolingCount = dataSource.getPoolingCount();
                int waitingThreadCount = dataSource.getWaitThreadCount();
                DruidCollector.INSTANCE.setCounts(activeCount, poolingCount, waitingThreadCount);
                DruidCollector.onStart(dataSource);
                TraceCollector.onStart((String)className, (String)methodName, (String)"Druid");
            }
        }
        catch (Exception e4) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)e4);
        }
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        try {
            if (DruidCollector.INSTANCE.isEnable()) {
                DruidCollector.onThrowable(e);
                ConnectionPoolUtils.setErrorMsg((Throwable)e);
            }
        }
        catch (Exception e2) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)e2);
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            if (DruidCollector.INSTANCE.isEnable()) {
                DruidCollector.onFinally();
                SpanEvent spanEvent = TraceCollector.onFinally((boolean)false);
                if (spanEvent != null && (spanEvent.getChildrenEventCount() > 0 || spanEvent.getTimeUsed() >= (long)DruidCollector.INSTANCE.getTimeSpanThreshold() || spanEvent.getHasError())) {
                    if (DruidCollector.INSTANCE.isGetPoolInfo()) {
                        Integer activeCountBefore = DruidCollector.INSTANCE.getActiveCount();
                        Integer poolingCountBefore = DruidCollector.INSTANCE.getPoolingCount();
                        Integer waitThreadCountBefore = DruidCollector.INSTANCE.getWaitThreadCount();
                        DruidCollector.INSTANCE.clearCounts();
                        if (activeCountBefore != null && poolingCountBefore != null && waitThreadCountBefore != null) {
                            DruidDataSource dataSource = (DruidDataSource)object;
                            int activeCountAfter = dataSource.getActiveCount();
                            int poolingCountAfter = dataSource.getPoolingCount();
                            int waitThreadCountAfter = dataSource.getWaitThreadCount();
                            String druidBeforeContext = "activeCount: " + activeCountBefore + "\n" + POOLING_COUNT + ": " + poolingCountBefore + "\n" + WAIT_THREAD_COUNT + ": " + waitThreadCountBefore;
                            String druidAfterContext = "activeCount: " + activeCountAfter + "\n" + POOLING_COUNT + ": " + poolingCountAfter + "\n" + WAIT_THREAD_COUNT + ": " + waitThreadCountAfter;
                            spanEvent.addTag(DRUID_BEFORE_GET_CONNECTION, druidBeforeContext);
                            spanEvent.addTag(DRUID_AFTER_GET_CONNECTION, druidAfterContext);
                        }
                    }
                    TraceCollector.sendSpanEvent((SpanEvent)spanEvent);
                }
            }
        }
        catch (Exception e3) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)e3);
        }
    }
}

