/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.rocketmq.producer.collector;

import com.lubanops.apm.bootstrap.collector.api.Collector;
import com.lubanops.apm.bootstrap.collector.api.MetricSetAggregator;
import com.lubanops.apm.bootstrap.plugin.common.DefaultExceptionAggregator;
import com.lubanops.apm.plugin.rocketmq.RocketMqUtils;
import com.lubanops.apm.plugin.rocketmq.producer.collector.RocketMqBrokerPublishAggregator;
import com.lubanops.apm.plugin.rocketmq.producer.collector.RocketMqClientIdPublishAggregator;
import com.lubanops.apm.plugin.rocketmq.producer.collector.RocketMqQueuePublishAggregator;
import com.lubanops.apm.plugin.rocketmq.producer.collector.RocketMqTopicPublishAggregator;
import com.lubanops.apm.plugin.rocketmq.producer.collector.RocketMqTransactionAggregator;
import java.util.Map;
import org.apache.rocketmq.common.message.MessageQueue;

public class RocketMqProducerCollector
extends Collector {
    public static final RocketMqProducerCollector INSTANCE = new RocketMqProducerCollector();
    public static final RocketMqClientIdPublishAggregator CLIENT_ID_AGGREGATOR = new RocketMqClientIdPublishAggregator();
    public static final RocketMqTopicPublishAggregator TOPIC_AGGREGATOR = new RocketMqTopicPublishAggregator();
    public static final RocketMqQueuePublishAggregator QUEUE_AGGREGATOR = new RocketMqQueuePublishAggregator();
    public static final RocketMqBrokerPublishAggregator BROKER_AGGREGATOR = new RocketMqBrokerPublishAggregator();
    public static final RocketMqTransactionAggregator TRANSACTION_AGGREGATOR = new RocketMqTransactionAggregator();
    public static final DefaultExceptionAggregator EXCEPTION_AGGREGATOR = new DefaultExceptionAggregator();

    public static void onTransactionStart(String clientId, String group) {
        TRANSACTION_AGGREGATOR.onStart(clientId, group);
    }

    public static void onTransactionFinally() {
        TRANSACTION_AGGREGATOR.onFinally();
    }

    public static void onTransactionError(String errorTraceId) {
        TRANSACTION_AGGREGATOR.onError(errorTraceId);
    }

    public static void onPublishStart(String clientId, String group, MessageQueue mq) {
        CLIENT_ID_AGGREGATOR.onStart(clientId, group);
        TOPIC_AGGREGATOR.onStart(clientId, group, mq.getTopic());
        QUEUE_AGGREGATOR.onStart(clientId, group, RocketMqUtils.constructQueueFromMq(mq));
    }

    public static void onPublishFinally(int msgCount, int msgBytes, boolean isSendFailed) {
        if (!isSendFailed) {
            CLIENT_ID_AGGREGATOR.incrementPublishedMsgCount(msgCount);
            CLIENT_ID_AGGREGATOR.incrementPublishedBytesCount(msgBytes);
            TOPIC_AGGREGATOR.incrementPublishedMsgCount(msgCount);
            TOPIC_AGGREGATOR.incrementPublishedBytesCount(msgBytes);
            QUEUE_AGGREGATOR.incrementPublishedMsgCount(msgCount);
            QUEUE_AGGREGATOR.incrementPublishedBytesCount(msgBytes);
        }
        CLIENT_ID_AGGREGATOR.onFinally();
        TOPIC_AGGREGATOR.onFinally();
        QUEUE_AGGREGATOR.onFinally();
    }

    public static void onPublishError(String errorTraceId) {
        CLIENT_ID_AGGREGATOR.onError(errorTraceId);
        TOPIC_AGGREGATOR.onError(errorTraceId);
        QUEUE_AGGREGATOR.onError(errorTraceId);
    }

    public static void onInnerSendStart(String clientId, String group, String broker) {
        BROKER_AGGREGATOR.onStart(clientId, group, broker);
    }

    public static void onInnerSendFinally(int msgCount, int msgBytes, boolean isSendFailed) {
        if (!isSendFailed) {
            BROKER_AGGREGATOR.incrementPublishedMsgCount(msgCount);
            BROKER_AGGREGATOR.incrementPublishedBytesCount(msgBytes);
        }
        BROKER_AGGREGATOR.onFinally();
    }

    public static void onInnerSendError(String errorTraceId) {
        BROKER_AGGREGATOR.onError(errorTraceId);
    }

    public static void onException(Throwable throwable) {
        EXCEPTION_AGGREGATOR.onThrowable(throwable);
    }

    public void parseParameter(Map<String, String> parameters) {
    }

    public String getCollectorName() {
        return "RocketMqProducer";
    }

    static {
        INSTANCE.addModelAggregator((MetricSetAggregator)CLIENT_ID_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)TOPIC_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)QUEUE_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)BROKER_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)TRANSACTION_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)EXCEPTION_AGGREGATOR);
        INSTANCE.register();
    }
}

