/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.rocketmq.common.stats;

import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.plugin.common.url.UrlStats;
import com.lubanops.apm.plugin.rocketmq.RocketMqPidMapper;
import java.util.concurrent.atomic.AtomicReference;

public class RocketMqInvokeStats
extends UrlStats {
    private String clientId;
    protected final AtomicReference<String> lastError = new AtomicReference();
    protected final AtomicReference<String> slowTraceId = new AtomicReference();
    protected final AtomicReference<String> errorTraceId = new AtomicReference();

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void onError(String errorTraceId) {
        this.onError();
        this.setErrorTraceId(errorTraceId);
    }

    public void setSlowTraceId(String slowTraceId) {
        if (slowTraceId != null) {
            this.slowTraceId.set(slowTraceId);
        }
    }

    public void setErrorTraceId(String errorTraceId) {
        if (this.errorTraceId.get() == null && errorTraceId != null) {
            this.errorTraceId.set(errorTraceId);
        }
    }

    public MonitorDataRow getStatus() {
        try {
            MonitorDataRow row = super.getStatus();
            row.put((Object)"lastError", (Object)this.lastError.get());
            row.put((Object)"slowTraceId", (Object)this.slowTraceId.get());
            row.put((Object)"errorTraceId", (Object)this.errorTraceId.get());
            row.put((Object)"pid", (Object)RocketMqPidMapper.getPid(this.getClientId()));
            return row;
        }
        catch (Exception e) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)e);
            return null;
        }
    }

    public MonitorDataRow harvest(int[] newRanges) {
        try {
            MonitorDataRow row = super.harvest(newRanges);
            if (row != null) {
                row.put((Object)"lastError", this.lastError.getAndSet(null));
                row.put((Object)"slowTraceId", this.slowTraceId.getAndSet(null));
                row.put((Object)"errorTraceId", this.errorTraceId.getAndSet(null));
                row.put((Object)"pid", (Object)RocketMqPidMapper.getPid(this.getClientId()));
            }
            return row;
        }
        catch (Exception e) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)e);
            return null;
        }
    }
}

