/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.plugin.httpclient.collector;

import com.lubanops.apm.bootstrap.plugin.httpclient.collector.PatternType;
import com.lubanops.apm.bootstrap.sample.SampleConfig;
import com.lubanops.apm.bootstrap.utils.AntPathMatcher;

public class UrlPattern
extends SampleConfig {
    private static AntPathMatcher matcher = new AntPathMatcher();
    private String method;
    private String pattern;
    private String target;

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getTargetUrl(String httpClientRealUrl) {
        if (httpClientRealUrl != null && this.pattern != null) {
            if (PatternType.startwith.value().equals(this.method)) {
                if (httpClientRealUrl.startsWith(this.pattern)) {
                    return this.target;
                }
            } else if (PatternType.endwith.value().equals(this.method)) {
                if (httpClientRealUrl.endsWith(this.pattern)) {
                    return this.target;
                }
            } else if (PatternType.include.value().equals(this.method)) {
                if (httpClientRealUrl.indexOf(this.pattern) > -1) {
                    return this.target;
                }
            } else if (PatternType.regex.value().equals(this.method)) {
                if (matcher.match(this.pattern, httpClientRealUrl)) {
                    return this.target;
                }
                if (this.pattern.startsWith("**") && matcher.match(this.pattern.substring(2), httpClientRealUrl)) {
                    return this.target;
                }
            }
        }
        return null;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }
}

