/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.plugin.httpclient.collector;

import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.collector.api.MultiPrimaryKeyAggregator;
import com.lubanops.apm.bootstrap.collector.api.PrimaryKey;
import com.lubanops.apm.bootstrap.config.IdentityConfigManager;
import com.lubanops.apm.bootstrap.plugin.httpclient.collector.InvocationStats;
import com.lubanops.apm.bootstrap.plugin.httpclient.collector.UrlPattern;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.bootstrap.transaction.TransactionCollector;
import com.lubanops.apm.bootstrap.utils.ParameterParseUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InvocationAggregator
extends MultiPrimaryKeyAggregator<InvocationStats> {
    public static final String STATS_KEY = "stats";
    public static final String STARTTIME_KEY = "starttime";
    public static final String ERROR_KEY = "error";
    public static final String TXNAME_KEY = "txName";
    public static final String HOST_KEY = "host";
    private static List<UrlPattern> patterns;
    private ThreadLocal<InvocationStats> statsLocal = new ThreadLocal();
    private ThreadLocal<Long> timeLocal = new ThreadLocal();
    private ThreadLocal<Boolean> errorLocal = new ThreadLocal();
    private ThreadLocal<String> hostLocal = new ThreadLocal();
    private String patternsStr;

    public String getName() {
        return "invocation";
    }

    public static List<UrlPattern> getPatterns() {
        return patterns;
    }

    public static void setPatterns(List<UrlPattern> patterns) {
        InvocationAggregator.patterns = patterns;
    }

    protected Class<InvocationStats> getValueType() {
        return InvocationStats.class;
    }

    protected int primaryKeyLength() {
        return 3;
    }

    public void parseParameters(Map<String, String> parameters) {
        int[] range = (int[])ParameterParseUtil.getParameterValue(parameters, (String)"httpClientRange", int[].class);
        if (range != null && range.length == 5) {
            this.setRanges(range);
        } else {
            this.setRanges(new int[]{10, 100, 500, 1000, 10000});
        }
        List patternArray = (List)ParameterParseUtil.getParameterValue(parameters, (String)"httpClientPattern", List.class, UrlPattern.class);
        String newPatternsStr = parameters.get("httpClientPattern");
        if (!(this.patternsStr == null && newPatternsStr == null || this.patternsStr != null && this.patternsStr.equals(newPatternsStr))) {
            this.patternsStr = newPatternsStr;
            this.clear();
        }
        patterns = patternArray;
    }

    protected List<String> primaryKey() {
        return Arrays.asList("url", "method", "client");
    }

    public List<MonitorDataRow> dump() {
        if (this.valueStats.isEmpty()) {
            return null;
        }
        ArrayList<MonitorDataRow> dumpList = new ArrayList<MonitorDataRow>();
        for (PrimaryKey key : this.valueStats.keySet()) {
            MonitorDataRow row = new MonitorDataRow();
            row.put((Object)"url", (Object)key.get(0));
            row.put((Object)"method", (Object)key.get(1));
            row.put((Object)"client", (Object)key.get(2));
            dumpList.add(row);
        }
        return dumpList;
    }

    public long onStart(String hostUri, String requestUri, String method, String client) {
        InvocationStats stats = (InvocationStats)this.getValue(new String[]{requestUri, method, client});
        if (stats.getHostUri() == null) {
            stats.setHostUri(hostUri);
        }
        this.statsLocal.set(stats);
        long t = stats.onStart();
        this.timeLocal.set(t);
        this.hostLocal.set(hostUri);
        return t;
    }

    public Map<String, Object> onStartAsync(String hostUri, String requestUri, String method, String client) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        InvocationStats stats = (InvocationStats)this.getValue(new String[]{requestUri, method, client});
        if (stats.getHostUri() == null) {
            stats.setHostUri(hostUri);
        }
        result.put(STATS_KEY, (Object)stats);
        this.statsLocal.set(stats);
        long t = stats.onStart();
        result.put(STARTTIME_KEY, t);
        this.timeLocal.set(t);
        result.put(HOST_KEY, hostUri);
        this.hostLocal.set(hostUri);
        result.put(TXNAME_KEY, TransactionCollector.getTxName());
        return result;
    }

    public boolean onThrowable(Throwable t) {
        InvocationStats stats = this.statsLocal.get();
        Long start = this.timeLocal.get();
        if (stats != null && start != null) {
            stats.setErrorTraceId(TraceCollector.getTraceId());
            stats.onThrowable(t);
            this.errorLocal.set(true);
            return true;
        }
        return false;
    }

    public boolean onThrowableAsync(Throwable t, Map<String, Object> map, String traceId) {
        InvocationStats stats = (InvocationStats)((Object)map.get(STATS_KEY));
        if (stats != null) {
            stats.setErrorTraceId(traceId);
            stats.onThrowable(t);
            map.put(ERROR_KEY, true);
            return true;
        }
        return false;
    }

    public boolean onError() {
        InvocationStats stats = this.statsLocal.get();
        if (stats != null) {
            stats.setErrorTraceId(TraceCollector.getTraceId());
            stats.incrementErrorCount();
            this.errorLocal.set(true);
            return true;
        }
        return false;
    }

    public boolean onErrorAsync(Map<String, Object> map, String traceId) {
        InvocationStats stats = (InvocationStats)((Object)map.get(STATS_KEY));
        if (stats != null) {
            stats.setErrorTraceId(traceId);
            stats.incrementErrorCount();
            map.put(ERROR_KEY, true);
            return true;
        }
        return false;
    }

    public void onResponseClose(String envId) {
        InvocationStats stats = this.statsLocal.get();
        Long start = this.timeLocal.get();
        Boolean error = this.errorLocal.get();
        if (error == null) {
            error = false;
        }
        if (stats != null && start != null) {
            if (stats.onResponseClose(start)) {
                stats.setSlowTraceId(TraceCollector.getTraceId());
            }
            if (stats.getEnvId() == null && envId != null) {
                stats.setEnvId(envId);
            }
            if ((envId = stats.getEnvId()) == null || "0".equals(envId)) {
                envId = stats.getHostUri();
            }
            Long timeUsed = System.nanoTime() - start;
            TransactionCollector.collect((long)timeUsed, (boolean)error, (String)String.valueOf(IdentityConfigManager.getEnvId()), (String)envId, (List)TransactionCollector.getTxName(), (String)"HttpClient");
        }
        this.statsLocal.remove();
        this.timeLocal.remove();
        this.errorLocal.remove();
    }

    public void clearThreadLocal() {
        super.clearThreadLocal();
        this.statsLocal.remove();
        this.timeLocal.remove();
        this.errorLocal.remove();
    }

    public void onResponseCloseAsync(String envId, Map map, String traceId) {
        InvocationStats stats = (InvocationStats)((Object)map.get(STATS_KEY));
        Long start = (Long)map.get(STARTTIME_KEY);
        Boolean error = (Boolean)map.get(ERROR_KEY);
        if (error == null) {
            error = false;
        }
        List txName = (List)map.get(TXNAME_KEY);
        if (stats != null && start != null) {
            if (stats.onResponseClose(start)) {
                stats.setSlowTraceId(traceId);
            }
            if (stats.getEnvId() == null && envId != null) {
                stats.setEnvId(envId);
            }
            if ((envId = stats.getEnvId()) == null || "0".equals(envId)) {
                envId = stats.getHostUri();
            }
            Long timeUsed = System.nanoTime() - start;
            TransactionCollector.collect((long)timeUsed, (boolean)error, (String)String.valueOf(IdentityConfigManager.getEnvId()), (String)envId, (List)txName, (String)"HttpClient");
        }
    }

    public void onResponseCloseAsyncWithoutTx(String envId, Map map, String traceId) {
        InvocationStats stats = (InvocationStats)((Object)map.get(STATS_KEY));
        Long start = (Long)map.get(STARTTIME_KEY);
        if (stats != null && start != null) {
            if (stats.onResponseClose(start)) {
                stats.setSlowTraceId(traceId);
            }
            if (stats.getEnvId() == null && envId != null) {
                stats.setEnvId(envId);
            }
        }
    }

    public Long getStartTime() {
        return this.timeLocal.get();
    }

    public Boolean getError() {
        Boolean isError = this.errorLocal.get();
        if (isError == null) {
            return false;
        }
        return isError;
    }

    public String getHost() {
        return this.hostLocal.get();
    }
}

