/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.integration.transport.websocket.future;

import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.log.Logger;
import com.lubanops.apm.integration.access.Message;
import com.lubanops.apm.integration.transport.websocket.future.MessageFuture;
import com.lubanops.apm.integration.utils.APMThreadFactory;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class FutureManagementService {
    private static final Logger LOGGER = LogFactory.getLogger();
    private static FutureManagementService instance = new FutureManagementService();
    private Map<Long, MessageFuture> futureMap = new ConcurrentHashMap<Long, MessageFuture>();
    private ScheduledExecutorService checkFutureExecutor = new ScheduledThreadPoolExecutor(1, new APMThreadFactory("FutureManagementService", true));

    private FutureManagementService() {
        this.checkFutureExecutor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    Set futureSet = FutureManagementService.this.futureMap.entrySet();
                    Iterator it = futureSet.iterator();
                    while (it.hasNext()) {
                        Map.Entry entry = it.next();
                        MessageFuture future = (MessageFuture)entry.getValue();
                        if (future.getFutureAge() <= 2000L) continue;
                        LOGGER.log(Level.FINE, String.format("----------timeout,messageid[%s]", ((MessageFuture)entry.getValue()).getMessage()));
                        it.remove();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }, 2000L, 10000L, TimeUnit.MILLISECONDS);
    }

    public static FutureManagementService getInstance() {
        return instance;
    }

    public MessageFuture getFuture(long messageId) {
        MessageFuture future = new MessageFuture(this, messageId, 2000L);
        this.futureMap.put(messageId, future);
        return future;
    }

    public void notifyFuture(Message message) {
        MessageFuture future = this.futureMap.remove(message.getMessageId());
        if (future != null) {
            future.taskFinished(message);
        }
    }

    public MessageFuture removeFuture(long id) {
        return this.futureMap.remove(id);
    }
}

