/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.integration.transport.websocket;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.huawei.cloud.profiler.commons.pap.v1.converters.PDebuggerRequestConverter;
import com.huawei.cloud.profiler.commons.pap.v1.converters.PDebuggerRequestConverterImpl;
import com.huawei.cloud.profiler.pap.v1.PDebuggerRequest;
import com.huawei.cloud.profiler.pap.v1.PDebuggerResponse;
import com.huawei.cloud.profiler.pap.v1.PayloadMetadata;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.log.Logger;
import com.lubanops.apm.bootstrap.profiler.ProfilerService;
import com.lubanops.apm.integration.access.Message;
import com.lubanops.apm.integration.access.outbound.SessionOpenRequest;
import com.lubanops.apm.integration.debugger.converters.ArthasModelToPDebuggerConverter;
import com.lubanops.apm.integration.debugger.service.job.CommandType;
import com.lubanops.apm.integration.debugger.service.job.DebugJobFactory;
import com.lubanops.apm.integration.debugger.service.message.ResponseMessageGenerator;
import com.lubanops.apm.integration.transport.websocket.future.FutureManagementService;
import com.lubanops.apm.integration.transport.websocket.future.MessageFuture;
import com.taobao.arthas.core.command.model.StatusModel;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.java_websocket.client.WebSocketClient;

public abstract class LubanWebSocketClient
extends WebSocketClient {
    private static final Logger LOGGER = LogFactory.getLogger();
    private boolean hasOpenResult = false;
    private CountDownLatch latch = new CountDownLatch(1);
    private boolean openResult = false;
    private final FutureManagementService futureManagementService = FutureManagementService.getInstance();
    private final String uri;
    private PDebuggerRequestConverter debuggerRequestConverter;
    private ResponseMessageGenerator reposnseMessageGenerator;
    private DebugJobFactory jobFactory;
    private boolean isDebuggerInitSuccess;
    private AtomicBoolean DEBUGGER_INIT = new AtomicBoolean(false);

    public LubanWebSocketClient(URI serverUri, String uri) {
        super(serverUri);
        this.uri = uri;
    }

    private void initDebugger() {
        this.isDebuggerInitSuccess = true;
        try {
            this.debuggerRequestConverter = new PDebuggerRequestConverterImpl();
            this.reposnseMessageGenerator = new ResponseMessageGenerator();
            this.jobFactory = new DebugJobFactory();
        }
        catch (Exception t) {
            this.isDebuggerInitSuccess = false;
            LOGGER.log(Level.INFO, "~~~~~ init snap debugger failed exception [" + t.getMessage() + "]");
        }
    }

    public void sendAsync(Message message) {
        super.send(message.toBytes());
        LOGGER.log(Level.FINE, "sendAsync,message id:" + message.getMessageId());
    }

    public Message sendSync(Message message) {
        Message response = null;
        MessageFuture future = this.futureManagementService.getFuture(message.getMessageId());
        super.send(message.toBytes());
        response = future.get();
        if (response == null) {
            LOGGER.log(Level.FINE, String.format("got nop response message,id:[%s]", message.getMessageId()));
        } else {
            LOGGER.log(Level.FINE, "got response message, id:" + message.getMessageId());
        }
        return response;
    }

    public void onMessage(String s) {
        LOGGER.log(Level.FINE, "onMessage message:" + s);
    }

    public void onMessage(ByteBuffer buffer) {
        int length = buffer.limit() - buffer.position();
        byte[] bytes = new byte[length];
        buffer.get(bytes);
        Message msg = Message.parseBytes(bytes);
        LOGGER.log(Level.FINE, " received message , id:" + msg.getMessageId());
        if (msg.getMessageId() == 0L) {
            LOGGER.log(Level.FINE, " received message , msg" + msg);
        }
        if (msg.getType() == 2) {
            this.futureManagementService.notifyFuture(msg);
        } else if (msg.getType() == 4) {
            this.futureManagementService.notifyFuture(msg);
        } else if (msg.getType() == 5) {
            SessionOpenRequest.SessionOpenHeader sessionOpenHeader = (SessionOpenRequest.SessionOpenHeader)JSON.parseObject((byte[])msg.getHeader(), SessionOpenRequest.SessionOpenHeader.class, (Feature[])new Feature[0]);
            if ("0".equals(sessionOpenHeader.getCode())) {
                this.openResult = true;
            } else {
                this.openResult = false;
                LOGGER.log(Level.SEVERE, "access_session_open_response id:" + msg.getMessageId() + " result:" + sessionOpenHeader.getMsg());
            }
            this.hasOpenResult = true;
            this.latch.countDown();
        } else if (msg.getType() == 13) {
            ProfilerService.getInstance().sessionControl(msg.getBody());
        } else if (msg.getType() == 19) {
            if (!this.DEBUGGER_INIT.getAndSet(true)) {
                this.initDebugger();
            }
            if (this.isDebuggerInitSuccess) {
                LOGGER.log(Level.INFO, "~~~~~ received Debug request: type [" + msg.getType() + "], id [" + msg.getMessageId() + "]");
                PDebuggerRequest request = this.debuggerRequestConverter.read(msg.getBody());
                PayloadMetadata payloadMD = request.getPayload().getPayloadMetadata();
                LOGGER.log(Level.INFO, "~~~~~ about to handle msg_id [" + msg.getMessageId() + "], request_id [" + payloadMD.getRequestId() + "]");
                PDebuggerResponse response = this.jobFactory.getJob(CommandType.valueOf(request.getPayload().getDataCase().name())).handleRequest(request);
                Message message = this.reposnseMessageGenerator.generateResponseMessage(msg, response);
                this.sendAsync(message);
                if (this.jobFactory.getJob(CommandType.valueOf(request.getPayload().getDataCase().name())).needReset()) {
                    this.jobFactory.getJob(CommandType.RESET_COMMAND).handleRequest(request);
                }
                LOGGER.log(Level.INFO, "~~~~~ sent Debug response: type [" + message.getType() + "], msg_id [" + message.getMessageId() + "], request_id [" + payloadMD.getRequestId() + "]");
            } else {
                LOGGER.log(Level.INFO, "~~~~~ received Debug request: type [" + msg.getType() + "], id [" + msg.getMessageId() + "] but javaagent init debugger failed");
                PDebuggerRequest request = this.debuggerRequestConverter.read(msg.getBody());
                PDebuggerResponse response = ArthasModelToPDebuggerConverter.createFailureResponse(request, new StatusModel(1, "The debugging function depends on the JDK environment."), false);
                PayloadMetadata payloadMD = request.getPayload().getPayloadMetadata();
                Message message = this.reposnseMessageGenerator.generateResponseMessage(msg, response);
                this.sendAsync(message);
                LOGGER.log(Level.INFO, "~~~~~ sent Debug response: type [" + message.getType() + "], msg_id [" + message.getMessageId() + "], request_id [" + payloadMD.getRequestId() + "]");
            }
        } else if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "can not enter here" + msg.getMessageId());
        }
    }

    public void onClose(int i, String s, boolean b) {
        LOGGER.log(Level.INFO, "onClose " + s + ", boolean:" + b);
    }

    public void onError(Exception e) {
        LOGGER.log(Level.SEVERE, "on error", (Throwable)e);
    }

    public String getUri() {
        return this.uri;
    }

    public boolean isHasOpenResult(long timeout) {
        try {
            this.latch.await(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.hasOpenResult;
    }

    public boolean isHasOpenResult() {
        return this.hasOpenResult;
    }

    public void setHasOpenResult(boolean hasOpenResult) {
        this.hasOpenResult = hasOpenResult;
    }

    public boolean getOpenResult() {
        return this.openResult;
    }

    public void setOpenResult(boolean openResult) {
        this.openResult = openResult;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("LubanWebSocketClient{");
        sb.append("uri=").append(this.uri);
        sb.append('}');
        return sb.toString();
    }
}

