/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.integration.debugger.service.message.command;

import com.lubanops.apm.integration.debugger.model.ArthasDebuggerCommand;
import com.lubanops.apm.integration.debugger.service.message.AbstractMessageProvider;
import com.lubanops.apm.integration.debugger.service.message.Requests;
import org.apache.commons.lang3.StringUtils;

public class TraceCommand
extends AbstractMessageProvider<TraceCommand> {
    @Override
    public Class<TraceCommand> getType() {
        return TraceCommand.class;
    }

    @Override
    public ArthasDebuggerCommand buildArthasCommand(Requests.Arguments commandArguments) {
        Requests.TraceArguments args = (Requests.TraceArguments)commandArguments;
        return this.toCommandLine(args);
    }

    private ArthasDebuggerCommand toCommandLine(Requests.TraceArguments args) {
        StringBuilder sb = new StringBuilder();
        sb.append("trace ");
        if (StringUtils.isBlank((CharSequence)args.getClassPattern())) {
            return new ArthasDebuggerCommand("", "Class pattern must have a value", false);
        }
        sb.append(args.getClassPattern());
        if (StringUtils.isBlank((CharSequence)args.getMethodPattern())) {
            return new ArthasDebuggerCommand("", "Method pattern must have a value", false);
        }
        sb.append(" " + args.getMethodPattern());
        if (!StringUtils.isBlank((CharSequence)args.getCondition())) {
            sb.append(" \"" + args.getCondition() + "\"");
        } else {
            sb.append(" \"\"");
        }
        sb.append(" -n 1 --skipJDKMethod false");
        return new ArthasDebuggerCommand(sb.toString(), "", true);
    }
}

