/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.integration.debugger.service.job;

import com.huawei.cloud.profiler.pap.v1.PDebuggerRequest;
import com.huawei.cloud.profiler.pap.v1.PDebuggerResponse;
import com.lubanops.apm.integration.debugger.converters.ArthasModelToPDebuggerConverter;
import com.lubanops.apm.integration.debugger.converters.WatchModelToPDebuggerResponseConverter;
import com.lubanops.apm.integration.debugger.handler.DebuggerCommandHandler;
import com.lubanops.apm.integration.debugger.model.ArthasDebuggerCommand;
import com.lubanops.apm.integration.debugger.service.job.AbstractJob;
import com.lubanops.apm.integration.debugger.service.job.CommandType;
import com.lubanops.apm.integration.debugger.service.message.Requests;
import com.lubanops.apm.integration.debugger.service.message.command.WatchCommand;
import com.taobao.arthas.core.command.model.ResultModel;
import com.taobao.arthas.core.command.model.StatusModel;
import com.taobao.arthas.core.command.model.WatchModel;
import com.taobao.arthas.core.distribution.PackingResultDistributor;
import com.taobao.arthas.core.distribution.impl.PackingResultDistributorImpl;
import com.taobao.arthas.core.shell.session.Session;

public class WatchJob
extends AbstractJob {
    private DebuggerCommandHandler debugCommandHandler;
    private Session session;
    private WatchCommand watchCommand;

    public WatchJob(DebuggerCommandHandler debuggerCommandHandler) {
        this.debugCommandHandler = debuggerCommandHandler;
        this.session = this.debugCommandHandler.getSession();
        this.watchCommand = new WatchCommand();
    }

    @Override
    public CommandType getType() {
        return CommandType.WATCH_COMMAND;
    }

    @Override
    public PDebuggerResponse handleRequest(PDebuggerRequest request) {
        PackingResultDistributorImpl packingResultDistributor = new PackingResultDistributorImpl(this.session);
        Requests.WatchArguments args = new Requests.WatchArguments();
        PDebuggerRequest.WatchCommand protoWatchCmd = request.getPayload().getWatchCommand();
        args.setClassPattern(protoWatchCmd.getClassPattern());
        args.setMethodPattern(protoWatchCmd.getMethodPattern());
        args.setExpression(protoWatchCmd.getExpression());
        args.setCondition(protoWatchCmd.getConditionExpression());
        args.setMaxIterableElements(protoWatchCmd.getMaxIterableElements());
        args.setMaxStringLength(protoWatchCmd.getMaxStringLength());
        this.setWatchDepths(args, protoWatchCmd);
        ArthasDebuggerCommand arthasDebuggerCommand = this.watchCommand.buildArthasCommand(args);
        if (!arthasDebuggerCommand.getSuccess().booleanValue()) {
            return ArthasModelToPDebuggerConverter.createFailureResponse(request, new StatusModel(1, arthasDebuggerCommand.getErrorMsg()), false);
        }
        Boolean expired = this.debugCommandHandler.handle(arthasDebuggerCommand.getCommand(), (PackingResultDistributor)packingResultDistributor);
        StatusModel statusModel = null;
        for (ResultModel result : packingResultDistributor.getResults()) {
            if (result instanceof WatchModel) {
                return WatchModelToPDebuggerResponseConverter.convert((WatchModel)result, request, args.getWatchDepths(), args.getMaxIterableElements(), args.getMaxStringLength());
            }
            if (!(result instanceof StatusModel)) continue;
            statusModel = (StatusModel)result;
        }
        return ArthasModelToPDebuggerConverter.createFailureResponse(request, statusModel, expired);
    }

    private void setWatchDepths(Requests.WatchArguments args, PDebuggerRequest.WatchCommand protoWatchCommand) {
        PDebuggerRequest.WatchDepths protoWatchDepths = protoWatchCommand.getDepths();
        Requests.WatchDepths watchDepths = new Requests.WatchDepths();
        watchDepths.setParams(protoWatchDepths.getParams());
        watchDepths.setReturnObj(protoWatchDepths.getReturnObj());
        watchDepths.setTarget(protoWatchDepths.getTarget());
        watchDepths.setExpression(protoWatchDepths.getExpression());
        args.setWatchDepths(watchDepths);
    }

    @Override
    public boolean needReset() {
        return true;
    }
}

