/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.integration.debugger.service.job;

import com.huawei.cloud.profiler.pap.v1.PDebuggerRequest;
import com.huawei.cloud.profiler.pap.v1.PDebuggerResponse;
import com.lubanops.apm.integration.debugger.converters.ArthasModelToPDebuggerConverter;
import com.lubanops.apm.integration.debugger.converters.VmToolModelToPDebuggerResponseConverter;
import com.lubanops.apm.integration.debugger.handler.DebuggerCommandHandler;
import com.lubanops.apm.integration.debugger.model.ArthasDebuggerCommand;
import com.lubanops.apm.integration.debugger.service.job.AbstractJob;
import com.lubanops.apm.integration.debugger.service.job.CommandType;
import com.lubanops.apm.integration.debugger.service.message.Requests;
import com.lubanops.apm.integration.debugger.service.message.command.VmToolCommand;
import com.taobao.arthas.core.command.model.ResultModel;
import com.taobao.arthas.core.command.model.StatusModel;
import com.taobao.arthas.core.command.model.VmToolModel;
import com.taobao.arthas.core.distribution.PackingResultDistributor;
import com.taobao.arthas.core.distribution.impl.PackingResultDistributorImpl;
import com.taobao.arthas.core.shell.session.Session;

public class ObjectJob
extends AbstractJob {
    private DebuggerCommandHandler debugCommandHandler;
    private Session session;
    private VmToolCommand vmtoolCommand;

    public ObjectJob(DebuggerCommandHandler debuggerCommandHandler) {
        this.debugCommandHandler = debuggerCommandHandler;
        this.session = this.debugCommandHandler.getSession();
        this.vmtoolCommand = new VmToolCommand();
    }

    @Override
    public CommandType getType() {
        return CommandType.OBJECT_COMMAND;
    }

    @Override
    public PDebuggerResponse handleRequest(PDebuggerRequest request) {
        PackingResultDistributorImpl packingResultDistributor = new PackingResultDistributorImpl(this.session);
        Requests.VmToolArguments args = new Requests.VmToolArguments();
        PDebuggerRequest.ObjectCommand objectCommand = request.getPayload().getObjectCommand();
        args.setClassPattern(objectCommand.getClassName());
        args.setHashClassLoader(objectCommand.getClassLoaderHash());
        args.setInstanceIndex(objectCommand.getInstanceIndex());
        args.setFiledName(objectCommand.getFieldName());
        ArthasDebuggerCommand arthasDebuggerCommand = this.vmtoolCommand.buildArthasCommand(args);
        if (!arthasDebuggerCommand.getSuccess().booleanValue()) {
            return ArthasModelToPDebuggerConverter.createFailureResponse(request, new StatusModel(1, arthasDebuggerCommand.getErrorMsg()), false);
        }
        Boolean expired = this.debugCommandHandler.handle(arthasDebuggerCommand.getCommand(), (PackingResultDistributor)packingResultDistributor);
        StatusModel statusModel = null;
        for (ResultModel result : packingResultDistributor.getResults()) {
            if (result instanceof VmToolModel) {
                return VmToolModelToPDebuggerResponseConverter.convertInstance((VmToolModel)result, request, objectCommand.getMaxDepth(), objectCommand.getMaxIterableElements(), objectCommand.getMaxStringLength());
            }
            if (!(result instanceof StatusModel)) continue;
            statusModel = (StatusModel)result;
        }
        return ArthasModelToPDebuggerConverter.createFailureResponse(request, statusModel, expired);
    }

    @Override
    public boolean needReset() {
        return false;
    }
}

