/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.integration.debugger.server;

import com.alibaba.arthas.deps.org.slf4j.Logger;
import com.alibaba.arthas.deps.org.slf4j.LoggerFactory;
import com.taobao.arthas.core.advisor.AdviceListener;
import com.taobao.arthas.core.advisor.AdviceWeaver;
import com.taobao.arthas.core.command.basic1000.HelpCommand;
import com.taobao.arthas.core.command.model.ResultModel;
import com.taobao.arthas.core.command.model.StatusModel;
import com.taobao.arthas.core.command.view.ResultViewResolver;
import com.taobao.arthas.core.distribution.ResultDistributor;
import com.taobao.arthas.core.distribution.impl.PackingResultDistributorImpl;
import com.taobao.arthas.core.distribution.impl.TermResultDistributorImpl;
import com.taobao.arthas.core.server.ArthasBootstrap;
import com.taobao.arthas.core.shell.cli.CliToken;
import com.taobao.arthas.core.shell.command.Command;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.arthas.core.shell.command.internal.CloseFunction;
import com.taobao.arthas.core.shell.command.internal.StatisticsFunction;
import com.taobao.arthas.core.shell.handlers.Handler;
import com.taobao.arthas.core.shell.session.Session;
import com.taobao.arthas.core.shell.system.ExecStatus;
import com.taobao.arthas.core.shell.system.Process;
import com.taobao.arthas.core.shell.system.ProcessAware;
import com.taobao.arthas.core.shell.term.Tty;
import com.taobao.middleware.cli.CLIException;
import com.taobao.middleware.cli.CommandLine;
import io.termd.core.function.Function;
import java.lang.instrument.ClassFileTransformer;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class DebuggerProcessImpl
implements Process {
    private static final Logger logger = LoggerFactory.getLogger(DebuggerProcessImpl.class);
    private final ScheduledExecutorService executorService;
    private Command commandContext;
    private Handler<CommandProcess> handler;
    private List<CliToken> args;
    private Tty tty;
    private Session session;
    private Handler<Void> interruptHandler;
    private Handler<Void> suspendHandler;
    private Handler<Void> resumeHandler;
    private Handler<Void> endHandler;
    private Handler<Void> backgroundHandler;
    private Handler<Void> foregroundHandler;
    private Handler<Integer> terminatedHandler;
    private boolean foreground;
    private ExecStatus processStatus;
    private boolean processForeground;
    private Handler<String> stdinHandler;
    private Handler<Void> resizeHandler;
    private Integer exitCode;
    private CommandProcessImpl process;
    private Date startTime;
    private ProcessOutput processOutput;
    private int jobId;
    private ResultDistributor resultDistributor;
    private ResultViewResolver resultViewResolver = new ResultViewResolver();

    public DebuggerProcessImpl(Command commandContext, List<CliToken> args, Handler<CommandProcess> handler, ProcessOutput processOutput, ResultDistributor resultDistributor) {
        this.commandContext = commandContext;
        this.handler = handler;
        this.args = args;
        this.resultDistributor = new PackingResultDistributorImpl(this.session);
        this.resultDistributor = resultDistributor;
        this.processStatus = ExecStatus.READY;
        this.processOutput = processOutput;
        this.executorService = Executors.newScheduledThreadPool(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "arthas-command-execute");
                t.setDaemon(true);
                return t;
            }
        });
    }

    public Integer exitCode() {
        return this.exitCode;
    }

    public ExecStatus status() {
        return this.processStatus;
    }

    public synchronized Process setTty(Tty tty) {
        this.tty = tty;
        return this;
    }

    public synchronized Tty getTty() {
        return this.tty;
    }

    public void setJobId(int jobId) {
        this.jobId = jobId;
    }

    public synchronized Process setSession(Session session) {
        this.session = session;
        return this;
    }

    public synchronized Session getSession() {
        return this.session;
    }

    public int times() {
        return this.process.times().get();
    }

    public Date startTime() {
        return this.startTime;
    }

    public String cacheLocation() {
        if (this.processOutput != null) {
            return this.processOutput.cacheLocation;
        }
        return null;
    }

    public Process terminatedHandler(Handler<Integer> handler) {
        this.terminatedHandler = handler;
        return this;
    }

    public boolean interrupt() {
        return this.interrupt(null);
    }

    public boolean interrupt(Handler<Void> completionHandler) {
        if (this.processStatus == ExecStatus.RUNNING || this.processStatus == ExecStatus.STOPPED) {
            Handler<Void> handler = this.interruptHandler;
            try {
                if (handler != null) {
                    handler.handle(null);
                }
            }
            finally {
                if (completionHandler != null) {
                    completionHandler.handle(null);
                }
            }
            return handler != null;
        }
        throw new IllegalStateException("Cannot interrupt process in " + this.processStatus + " state");
    }

    public void resume() {
        this.resume(true);
    }

    public void resume(boolean foreground) {
        this.resume(foreground, null);
    }

    public void resume(Handler<Void> completionHandler) {
        this.resume(true, completionHandler);
    }

    public synchronized void resume(boolean fg, Handler<Void> completionHandler) {
        if (this.processStatus == ExecStatus.STOPPED) {
            this.updateStatus(ExecStatus.RUNNING, null, fg, this.resumeHandler, this.terminatedHandler, completionHandler);
            if (this.process != null) {
                this.process.resume();
            }
        } else {
            throw new IllegalStateException("Cannot resume process in " + this.processStatus + " state");
        }
    }

    public void suspend() {
        this.suspend(null);
    }

    public synchronized void suspend(Handler<Void> completionHandler) {
        if (this.processStatus == ExecStatus.RUNNING) {
            this.updateStatus(ExecStatus.STOPPED, null, false, this.suspendHandler, this.terminatedHandler, completionHandler);
            if (this.process != null) {
                this.process.suspend();
            }
        } else {
            throw new IllegalStateException("Cannot suspend process in " + this.processStatus + " state");
        }
    }

    public void toBackground() {
        this.toBackground(null);
    }

    public void toBackground(Handler<Void> completionHandler) {
        if (this.processStatus == ExecStatus.RUNNING) {
            if (this.processForeground) {
                this.updateStatus(ExecStatus.RUNNING, null, false, this.backgroundHandler, this.terminatedHandler, completionHandler);
            }
        } else {
            throw new IllegalStateException("Cannot set to background a process in " + this.processStatus + " state");
        }
    }

    public void toForeground() {
        this.toForeground(null);
    }

    public void toForeground(Handler<Void> completionHandler) {
        if (this.processStatus == ExecStatus.RUNNING) {
            if (!this.processForeground) {
                this.updateStatus(ExecStatus.RUNNING, null, true, this.foregroundHandler, this.terminatedHandler, completionHandler);
            }
        } else {
            throw new IllegalStateException("Cannot set to foreground a process in " + this.processStatus + " state");
        }
    }

    public void terminate() {
        this.terminate(null);
    }

    public void terminate(Handler<Void> completionHandler) {
        if (!this.terminate(-10, completionHandler, null)) {
            throw new IllegalStateException("Cannot terminate terminated process");
        }
    }

    private synchronized boolean terminate(int exitCode, Handler<Void> completionHandler, String message) {
        if (this.processStatus != ExecStatus.TERMINATED) {
            this.appendResult((ResultModel)new StatusModel(exitCode, message));
            if (this.process != null) {
                this.processOutput.close();
            }
            this.updateStatus(ExecStatus.TERMINATED, exitCode, false, this.endHandler, this.terminatedHandler, completionHandler);
            if (this.process != null) {
                this.process.unregister();
            }
            this.executorService.shutdownNow();
            return true;
        }
        this.executorService.shutdownNow();
        return false;
    }

    private void appendResult(ResultModel result) {
        result.setJobId(this.jobId);
        if (this.resultDistributor != null) {
            this.resultDistributor.appendResult(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateStatus(ExecStatus statusUpdate, Integer exitCodeUpdate, boolean foregroundUpdate, Handler<Void> handler, Handler<Integer> terminatedHandler, Handler<Void> completionHandler) {
        this.processStatus = statusUpdate;
        this.exitCode = exitCodeUpdate;
        if (!foregroundUpdate) {
            if (this.processForeground) {
                this.processForeground = false;
                if (this.stdinHandler != null) {
                    this.tty.stdinHandler(null);
                }
                if (this.resizeHandler != null) {
                    this.tty.resizehandler(null);
                }
            }
        } else if (!this.processForeground) {
            this.processForeground = true;
            if (this.stdinHandler != null) {
                this.tty.stdinHandler(this.stdinHandler);
            }
            if (this.resizeHandler != null) {
                this.tty.resizehandler(this.resizeHandler);
            }
        }
        this.foreground = foregroundUpdate;
        try {
            if (handler != null) {
                handler.handle(null);
            }
        }
        finally {
            if (completionHandler != null) {
                completionHandler.handle(null);
            }
            if (terminatedHandler != null && statusUpdate == ExecStatus.TERMINATED) {
                terminatedHandler.handle((Object)exitCodeUpdate);
            }
        }
    }

    public void run() {
        this.run(true);
    }

    public synchronized void run(boolean fg) {
        if (this.processStatus != ExecStatus.READY) {
            throw new IllegalStateException("Cannot run proces in " + this.processStatus + " state");
        }
        this.processStatus = ExecStatus.RUNNING;
        this.processForeground = fg;
        this.foreground = fg;
        this.startTime = new Date();
        Tty tty = this.tty;
        if (tty == null) {
            throw new IllegalStateException("Cannot execute process without a TTY set");
        }
        this.process = new CommandProcessImpl(this, tty);
        if (this.resultDistributor == null) {
            this.resultDistributor = new TermResultDistributorImpl((CommandProcess)this.process, this.resultViewResolver);
        }
        LinkedList<String> args2 = new LinkedList<String>();
        for (CliToken arg : this.args) {
            if (!arg.isText()) continue;
            args2.add(arg.value());
        }
        CommandLine cl = null;
        try {
            if (this.commandContext.cli() != null) {
                if (this.commandContext.cli().parse(args2, false).isAskingForHelp()) {
                    this.appendResult((ResultModel)new HelpCommand().createHelpDetailModel(this.commandContext));
                    this.terminate();
                    return;
                }
                cl = this.commandContext.cli().parse(args2);
                this.process.setArgs2(args2);
                this.process.setCommandLine(cl);
            }
        }
        catch (CLIException e) {
            this.terminate(-10, null, e.getMessage());
            return;
        }
        if (this.cacheLocation() != null) {
            this.process.echoTips("job id  : " + this.jobId + "\n");
            this.process.echoTips("cache location  : " + this.cacheLocation() + "\n");
        }
        CommandProcessTask task = new CommandProcessTask(this.process);
        this.execute(task);
    }

    public void execute(Runnable command) {
        this.executorService.execute(command);
    }

    public static void main(String[] args) throws Throwable {
        ArthasBootstrap.getInstance(null, new HashMap());
    }

    static class ProcessOutput {
        private List<Function<String, String>> stdoutHandlerChain;
        private StatisticsFunction statisticsHandler = null;
        private List<Function<String, String>> flushHandlerChain = null;
        private String cacheLocation;
        private Tty term;

        public ProcessOutput(List<Function<String, String>> stdoutHandlerChain, String cacheLocation, Tty term) {
            int i;
            for (i = 0; i < stdoutHandlerChain.size() && !(stdoutHandlerChain.get(i) instanceof StatisticsFunction); ++i) {
            }
            if (i < stdoutHandlerChain.size()) {
                this.stdoutHandlerChain = stdoutHandlerChain.subList(0, i + 1);
                this.statisticsHandler = (StatisticsFunction)stdoutHandlerChain.get(i);
                if (i < stdoutHandlerChain.size() - 1) {
                    this.flushHandlerChain = stdoutHandlerChain.subList(i + 1, stdoutHandlerChain.size());
                }
            } else {
                this.stdoutHandlerChain = stdoutHandlerChain;
            }
            this.cacheLocation = cacheLocation;
            this.term = term;
        }

        private void write(String data) {
            if (this.stdoutHandlerChain != null) {
                int size = this.stdoutHandlerChain.size();
                for (int i = 0; i < size; ++i) {
                    Function<String, String> function = this.stdoutHandlerChain.get(i);
                    data = (String)function.apply((Object)data);
                }
            }
        }

        private void close() {
            if (this.statisticsHandler != null && this.flushHandlerChain != null) {
                String data = this.statisticsHandler.result();
                for (Function<String, String> function : this.flushHandlerChain) {
                    data = (String)function.apply((Object)data);
                    if (!(function instanceof StatisticsFunction)) continue;
                    data = ((StatisticsFunction)function).result();
                }
            }
            if (this.stdoutHandlerChain != null) {
                for (Function<String, String> function : this.stdoutHandlerChain) {
                    if (!(function instanceof CloseFunction)) continue;
                    ((CloseFunction)function).close();
                }
            }
        }
    }

    private class CommandProcessImpl
    implements CommandProcess {
        private final Process process;
        private final Tty tty;
        private List<String> args2;
        private CommandLine commandLine;
        private AtomicInteger times = new AtomicInteger();
        private AdviceListener listener = null;
        private ClassFileTransformer transformer;

        public CommandProcessImpl(Process process, Tty tty) {
            this.process = process;
            this.tty = tty;
        }

        public List<CliToken> argsTokens() {
            return DebuggerProcessImpl.this.args;
        }

        public List<String> args() {
            return this.args2;
        }

        public String type() {
            return this.tty.type();
        }

        public boolean isForeground() {
            return DebuggerProcessImpl.this.foreground;
        }

        public int width() {
            return this.tty.width();
        }

        public int height() {
            return this.tty.height();
        }

        public CommandLine commandLine() {
            return this.commandLine;
        }

        public Session session() {
            return DebuggerProcessImpl.this.session;
        }

        public AtomicInteger times() {
            return this.times;
        }

        public void setArgs2(List<String> args2) {
            this.args2 = args2;
        }

        public void setCommandLine(CommandLine commandLine) {
            this.commandLine = commandLine;
        }

        public CommandProcess stdinHandler(Handler<String> handler) {
            DebuggerProcessImpl.this.stdinHandler = handler;
            if (DebuggerProcessImpl.this.processForeground && DebuggerProcessImpl.this.stdinHandler != null) {
                this.tty.stdinHandler(DebuggerProcessImpl.this.stdinHandler);
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CommandProcess write(String data) {
            DebuggerProcessImpl debuggerProcessImpl = DebuggerProcessImpl.this;
            synchronized (debuggerProcessImpl) {
                if (DebuggerProcessImpl.this.processStatus != ExecStatus.RUNNING) {
                    throw new IllegalStateException("Cannot write to standard output when " + DebuggerProcessImpl.this.status().name().toLowerCase());
                }
            }
            DebuggerProcessImpl.this.processOutput.write(data);
            return this;
        }

        public void echoTips(String tips) {
            DebuggerProcessImpl.this.processOutput.term.write(tips);
        }

        public String cacheLocation() {
            return DebuggerProcessImpl.this.cacheLocation();
        }

        public CommandProcess resizehandler(Handler<Void> handler) {
            DebuggerProcessImpl.this.resizeHandler = handler;
            this.tty.resizehandler(DebuggerProcessImpl.this.resizeHandler);
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CommandProcess interruptHandler(Handler<Void> handler) {
            DebuggerProcessImpl debuggerProcessImpl = DebuggerProcessImpl.this;
            synchronized (debuggerProcessImpl) {
                DebuggerProcessImpl.this.interruptHandler = handler;
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CommandProcess suspendHandler(Handler<Void> handler) {
            DebuggerProcessImpl debuggerProcessImpl = DebuggerProcessImpl.this;
            synchronized (debuggerProcessImpl) {
                DebuggerProcessImpl.this.suspendHandler = handler;
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CommandProcess resumeHandler(Handler<Void> handler) {
            DebuggerProcessImpl debuggerProcessImpl = DebuggerProcessImpl.this;
            synchronized (debuggerProcessImpl) {
                DebuggerProcessImpl.this.resumeHandler = handler;
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CommandProcess endHandler(Handler<Void> handler) {
            DebuggerProcessImpl debuggerProcessImpl = DebuggerProcessImpl.this;
            synchronized (debuggerProcessImpl) {
                DebuggerProcessImpl.this.endHandler = handler;
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CommandProcess backgroundHandler(Handler<Void> handler) {
            DebuggerProcessImpl debuggerProcessImpl = DebuggerProcessImpl.this;
            synchronized (debuggerProcessImpl) {
                DebuggerProcessImpl.this.backgroundHandler = handler;
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CommandProcess foregroundHandler(Handler<Void> handler) {
            DebuggerProcessImpl debuggerProcessImpl = DebuggerProcessImpl.this;
            synchronized (debuggerProcessImpl) {
                DebuggerProcessImpl.this.foregroundHandler = handler;
            }
            return this;
        }

        public void register(AdviceListener adviceListener, ClassFileTransformer transformer) {
            ProcessAware processAware;
            if (adviceListener instanceof ProcessAware && (processAware = (ProcessAware)adviceListener).getProcess() == null) {
                processAware.setProcess(this.process);
            }
            this.listener = adviceListener;
            AdviceWeaver.reg((AdviceListener)this.listener);
            this.transformer = transformer;
        }

        public void unregister() {
            if (this.transformer != null) {
                ArthasBootstrap.getInstance().getTransformerManager().removeTransformer(this.transformer);
            }
            if (this.listener instanceof ProcessAware) {
                if (this.process.equals(((ProcessAware)this.listener).getProcess())) {
                    AdviceWeaver.unReg((AdviceListener)this.listener);
                }
            } else {
                AdviceWeaver.unReg((AdviceListener)this.listener);
            }
        }

        public void resume() {
        }

        public void suspend() {
        }

        public void end() {
            this.end(0);
        }

        public void end(int statusCode) {
            this.end(statusCode, null);
        }

        public void end(int statusCode, String message) {
            DebuggerProcessImpl.this.terminate(statusCode, (Handler<Void>)null, message);
        }

        public boolean isRunning() {
            return DebuggerProcessImpl.this.processStatus == ExecStatus.RUNNING;
        }

        public void appendResult(ResultModel result) {
            if (DebuggerProcessImpl.this.processStatus != ExecStatus.RUNNING) {
                throw new IllegalStateException("Cannot write to standard output when " + DebuggerProcessImpl.this.status().name().toLowerCase());
            }
            DebuggerProcessImpl.this.appendResult(result);
        }
    }

    private class CommandProcessTask
    implements Runnable {
        private CommandProcess process;

        public CommandProcessTask(CommandProcess process) {
            this.process = process;
        }

        @Override
        public void run() {
            try {
                DebuggerProcessImpl.this.handler.handle((Object)this.process);
            }
            catch (Throwable t) {
                logger.error("Error during processing the command:", t);
                this.process.end(1, "Error during processing the command: " + t.getClass().getName() + ", message:" + t.getMessage() + ", please check $HOME/logs/arthas/arthas.log for more details.");
            }
        }
    }
}

