/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.integration.debugger.converters;

import com.huawei.cloud.profiler.pap.v1.PDebuggerRequest;
import com.huawei.cloud.profiler.pap.v1.PDebuggerResponse;
import com.lubanops.apm.integration.debugger.converters.ArthasModelToPDebuggerConverter;
import com.lubanops.apm.integration.debugger.converters.ConversionUtils;
import com.taobao.arthas.core.command.model.ClassVO;
import com.taobao.arthas.core.command.model.JadModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class JadModelToPDebuggerResponseConverter
extends ArthasModelToPDebuggerConverter {
    public static PDebuggerResponse convert(JadModel jadModel, PDebuggerRequest request) {
        PDebuggerResponse.JadResponse jadResponse = JadModelToPDebuggerResponseConverter.createJadResponse(jadModel);
        PDebuggerResponse.Payload.Builder payloadBuilder = PDebuggerResponse.Payload.newBuilder().setJadResponse(jadResponse);
        return JadModelToPDebuggerResponseConverter.buildPDebuggerResponse(payloadBuilder, request.getPayload().getPayloadMetadata(), request.getMetadata());
    }

    private static PDebuggerResponse.JadResponse createJadResponse(JadModel jadModel) {
        ArrayList<PDebuggerResponse.JadResponse.ClassVO> matchedClasses = new ArrayList<PDebuggerResponse.JadResponse.ClassVO>();
        if (!ConversionUtils.isEmpty(jadModel.getMatchedClasses())) {
            for (ClassVO clazz : jadModel.getMatchedClasses()) {
                matchedClasses.add(JadModelToPDebuggerResponseConverter.classVoPopulator(clazz));
            }
        }
        return PDebuggerResponse.JadResponse.newBuilder().setClassInfo(JadModelToPDebuggerResponseConverter.classVoPopulator(jadModel.getClassInfo())).setSource(jadModel.getSource()).setLocation(jadModel.getLocation()).putAllMappings(JadModelToPDebuggerResponseConverter.toMap(jadModel.getMappings())).setClassLoaderClass(jadModel.getClassLoaderClass() != null ? jadModel.getClassLoaderClass() : "").addAllMatchedClasses(matchedClasses).build();
    }

    private static Map<Integer, Integer> toMap(Map<Integer, Integer> mappings) {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        mappings.forEach((k, v) -> {
            if (v != null) {
                map.put((Integer)k, (Integer)v);
            }
        });
        return map;
    }

    private static PDebuggerResponse.JadResponse.ClassVO classVoPopulator(ClassVO classInfo) {
        return PDebuggerResponse.JadResponse.ClassVO.newBuilder().setName(classInfo.getName()).setClassLoaderHash(classInfo.getClassLoaderHash()).build();
    }
}

