/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.integration.debugger.converters;

import com.alibaba.arthas.deps.org.slf4j.Logger;
import com.alibaba.arthas.deps.org.slf4j.LoggerFactory;
import com.lubanops.apm.integration.debugger.converters.SerializationParameters;
import com.lubanops.apm.integration.debugger.converters.SupportedLoggingRegistry;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import lombok.NonNull;
import org.apache.commons.lang3.ObjectUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ArthasSerializationHelper {
    private static final Logger log = LoggerFactory.getLogger(ArthasSerializationHelper.class);
    private static final Set<Class<?>> leafClasses = new HashSet();

    public String serializeObject(String jpath, Object object, int depth, int maxIterableElements, int maxStringLength) {
        if (ObjectUtils.isEmpty((Object)object)) {
            return "null";
        }
        SerializationParameters params = new SerializationParameters(depth, maxIterableElements, maxStringLength);
        String json = this.serialize(jpath, object, params);
        if (json == null) {
            json = "null";
        }
        return json;
    }

    public String serialize(String jpath, Object value, SerializationParameters params) {
        IdentityHashMap<Object, String> visitedObjects = new IdentityHashMap<Object, String>();
        Object result = this.doSerialize(jpath, false, value, visitedObjects, params.getMaxDepth(), params.getMaxElementsInArray(), params.getMaxStringLength());
        return result == null ? null : result.toString();
    }

    private boolean isLeafType(Object value) {
        if (Enum.class.isAssignableFrom(value.getClass())) {
            return true;
        }
        return leafClasses.contains(value.getClass());
    }

    private Object doSerialize(String jpath, boolean internalCall, Object currObject, IdentityHashMap<Object, String> visitedObjects, int currDepth, int maxNumOfElementsInArray, int maxStringLength) {
        if (currObject == null) {
            return "null";
        }
        if (currDepth == 0) {
            String objAsShortStr = currObject.toString();
            objAsShortStr = this.truncateString(objAsShortStr, maxStringLength);
            return objAsShortStr + " (max depth reached)";
        }
        if (this.isLeafType(currObject)) {
            return this.serializeLeaf(currObject, internalCall, maxStringLength);
        }
        if (SupportedLoggingRegistry.isLoggingType(currObject)) {
            return this.serializeLogger(currObject);
        }
        if (visitedObjects.containsKey(currObject)) {
            log.warn("Found Circular reference");
            String jPathValue = visitedObjects.get(currObject);
            return this.createJasonPathRef(jPathValue);
        }
        visitedObjects.put(currObject, jpath);
        if (currObject.getClass().isArray()) {
            return this.serializeArray(jpath, currObject, visitedObjects, currDepth, maxNumOfElementsInArray, maxStringLength);
        }
        if (Collection.class.isAssignableFrom(currObject.getClass())) {
            return this.serializeCollection(jpath, (Collection)currObject, visitedObjects, currDepth, maxNumOfElementsInArray, maxStringLength);
        }
        if (Map.class.isAssignableFrom(currObject.getClass())) {
            return this.serializeMap(jpath, (Map)currObject, visitedObjects, currDepth, maxNumOfElementsInArray, maxStringLength);
        }
        if (Throwable.class.isAssignableFrom(currObject.getClass())) {
            return this.serializeException((Throwable)currObject);
        }
        return this.serializeCompoundObject(jpath, currObject, visitedObjects, currDepth, maxNumOfElementsInArray, maxStringLength);
    }

    private JSONObject createJasonPathRef(String jpath) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("jpath", (Object)jpath);
        return jsonObject;
    }

    private JSONObject serializeException(Throwable throwable) {
        StringBuilder sb = new StringBuilder();
        sb.append(throwable.toString()).append("\n");
        Arrays.stream(throwable.getStackTrace()).forEach(stElement -> sb.append("\tat ").append(stElement.toString()).append("\n"));
        JSONObject result = new JSONObject();
        result.put("type", (Object)throwable.getClass().getTypeName());
        result.put("value", (Object)sb.toString());
        return result;
    }

    @NonNull
    private JSONObject serializeCompoundObject(String jpath, Object currObject, IdentityHashMap<Object, String> visitedObjects, int currDepth, int maxNumOfElementsInArray, int maxStringLength) {
        Field[] fields = currObject.getClass().getDeclaredFields();
        String type = currObject.getClass().getTypeName();
        boolean isMap = type.equals("com.lubanops.apm.integration.debugger.converters.ArthasSerializationHelper$Pair");
        String nextJPath = isMap ? jpath : jpath + ".value";
        JSONObject result = new JSONObject();
        for (Field field : fields) {
            this.withFieldGrantedAccess(field, currObject, () -> {
                String name = field.getName();
                try {
                    Object value = field.get(currObject);
                    Object serializedValue = this.doSerialize(nextJPath + "." + name, true, value, visitedObjects, currDepth - 1, maxNumOfElementsInArray, maxStringLength);
                    result.put(name, serializedValue);
                }
                catch (JSONException ex) {
                    log.warn("Failed to process json of object [ {} ] at path [ {} ]", new Object[]{name, nextJPath, ex});
                }
                catch (IllegalAccessException ex) {
                    log.warn("Failed to access the object [ {} ] at path [ {} ]", new Object[]{name, nextJPath, ex});
                }
                catch (ConcurrentModificationException ex) {
                    log.warn("Failed to serialize object [ {} ] at path [ {} ] due to ConcurrentModificationException", new Object[]{name, nextJPath, ex});
                }
                catch (Exception ex) {
                    log.warn("Failed to serialize object [ {} ] at path [ {} ]", new Object[]{name, nextJPath, ex});
                }
            });
        }
        if (!isMap) {
            JSONObject node = new JSONObject();
            node.put("type", (Object)type);
            node.put("value", (Object)result);
            return node;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void withFieldGrantedAccess(Field field, Object currObject, Runnable codeBlock) {
        boolean isAccessibleStatus = field.isAccessible();
        try {
            if (!isAccessibleStatus) {
                field.setAccessible(true);
            }
            codeBlock.run();
        }
        finally {
            if (!isAccessibleStatus) {
                field.setAccessible(false);
            }
        }
    }

    private String truncateString(String value, int maxStringLength) {
        if (ObjectUtils.isEmpty((Object)value)) {
            return value;
        }
        int maxLength = Math.min(value.length(), maxStringLength);
        return value.substring(0, maxLength);
    }

    private Object serializeLeaf(Object value, boolean internalCall, int maxStringLength) {
        if (String.class.isAssignableFrom(value.getClass())) {
            value = this.truncateString((String)value, maxStringLength);
        }
        if (internalCall) {
            return value;
        }
        String type = value.getClass().getTypeName();
        JSONObject result = new JSONObject();
        result.put("type", (Object)type);
        result.put("value", value);
        return result;
    }

    private Object serializeLogger(Object value) {
        String type = value.getClass().getTypeName();
        JSONObject result = new JSONObject();
        result.put("type", (Object)type);
        result.put("value", value);
        return result;
    }

    private JSONObject serializeArray(String jpath, Object array, IdentityHashMap<Object, String> visitedObjects, int currDepth, int maxNumOfElementsInArray, int maxStringLength) {
        Iterator iterator = Stream.iterate(0, i -> i + 1).limit(Array.getLength(array)).map(i -> Array.get(array, i)).iterator();
        return this.convertByIterator(jpath, Array.getLength(array), array.getClass().getTypeName(), iterator, visitedObjects, currDepth, maxNumOfElementsInArray, maxStringLength);
    }

    private JSONObject serializeCollection(String jpath, Collection<?> collection, IdentityHashMap<Object, String> visitedObjects, int currDepth, int maxNumOfElementsInArray, int maxStringLength) {
        Iterator<?> iterator = collection.iterator();
        return this.convertByIterator(jpath, collection.size(), collection.getClass().getTypeName(), iterator, visitedObjects, currDepth, maxNumOfElementsInArray, maxStringLength);
    }

    private Object serializeMap(String jpath, Map<?, ?> map, IdentityHashMap<Object, String> visitedObjects, int currDepth, int maxNumOfElementsInArray, int maxStringLength) {
        Iterator mapIt = map.entrySet().stream().map(e -> new Pair(e.getKey(), e.getValue())).iterator();
        return this.convertByIterator(jpath, map.size(), map.getClass().getTypeName(), mapIt, visitedObjects, currDepth, maxNumOfElementsInArray, maxStringLength);
    }

    private JSONObject convertByIterator(String jpath, int size, String type, Iterator<?> iterator, IdentityHashMap<Object, String> visitedObjects, int currDepth, int maxNumOfElementsInArray, int maxStringLength) {
        JSONObject result = new JSONObject();
        result.put("size", size);
        result.put("type", (Object)type);
        if (currDepth == 0) {
            log.info("Reached max depth");
            result.put("value", (Object)"(max depth reached)");
            return result;
        }
        JSONArray elements = new JSONArray();
        int currIndex = 0;
        while (iterator.hasNext()) {
            String elementJPath = jpath + ".value[" + currIndex + "]";
            if (currIndex++ >= maxNumOfElementsInArray) {
                log.info("Reached max elements of array [{}]", (Object)maxNumOfElementsInArray);
                break;
            }
            Object value = iterator.next();
            Object serializedValue = this.doSerialize(elementJPath, true, value, visitedObjects, currDepth, maxNumOfElementsInArray, maxStringLength);
            elements.put(serializedValue);
        }
        result.put("value", (Object)elements);
        return result;
    }

    static {
        leafClasses.add(Integer.TYPE);
        leafClasses.add(Float.TYPE);
        leafClasses.add(Boolean.TYPE);
        leafClasses.add(Double.TYPE);
        leafClasses.add(Long.TYPE);
        leafClasses.add(Character.TYPE);
        leafClasses.add(Short.TYPE);
        leafClasses.add(String.class);
        leafClasses.add(Integer.class);
        leafClasses.add(Float.class);
        leafClasses.add(Boolean.class);
        leafClasses.add(Double.class);
        leafClasses.add(Long.class);
        leafClasses.add(Character.class);
        leafClasses.add(Short.class);
        leafClasses.add(Date.class);
        leafClasses.add(Instant.class);
        leafClasses.add(LocalDate.class);
        leafClasses.add(LocalDateTime.class);
    }

    public static final class Pair<K, V> {
        private final K key;
        private final V value;

        public Pair(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Pair)) {
                return false;
            }
            Pair other = (Pair)o;
            K this$key = this.getKey();
            K other$key = other.getKey();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            V this$value = this.getValue();
            V other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            K $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            V $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        public String toString() {
            return "ArthasSerializationHelper.Pair(key=" + this.getKey() + ", value=" + this.getValue() + ")";
        }
    }
}

