/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.hbase.stats;

import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.plugin.common.DefaultSectionStats;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class HBaseClientStats
extends DefaultSectionStats {
    private final AtomicReference<String> lastError = new AtomicReference();
    private final AtomicReference<String> slowTraceId = new AtomicReference();
    private final AtomicReference<String> errorTraceId = new AtomicReference();
    private final AtomicLong queryRowCount = new AtomicLong();
    private final AtomicLong updateRowCount = new AtomicLong();

    public void incrementQueryRowCount(long count) {
        this.queryRowCount.addAndGet(count);
    }

    public void incrementUpdateRowCount(long count) {
        this.updateRowCount.addAndGet(count);
    }

    public void onError(String errorTraceId) {
        this.onError();
        this.setErrorTraceId(errorTraceId);
    }

    public void setSlowTraceId(String slowTraceId) {
        if (slowTraceId != null) {
            this.slowTraceId.set(slowTraceId);
        }
    }

    public void setErrorTraceId(String errorTraceId) {
        if (this.errorTraceId.get() == null && errorTraceId != null) {
            this.errorTraceId.set(errorTraceId);
        }
    }

    public MonitorDataRow getStatus() {
        MonitorDataRow row = super.getStatus();
        row.put((Object)"lastError", (Object)this.lastError.get());
        row.put((Object)"slowTraceId", (Object)this.slowTraceId.get());
        row.put((Object)"errorTraceId", (Object)this.errorTraceId.get());
        row.put((Object)"queryRowCount", (Object)this.queryRowCount.get());
        row.put((Object)"updateRowCount", (Object)this.updateRowCount.get());
        return row;
    }

    public MonitorDataRow harvest(int[] newRanges) {
        MonitorDataRow row = super.harvest(newRanges);
        if (row == null) {
            return null;
        }
        row.put((Object)"lastError", this.lastError.getAndSet(null));
        row.put((Object)"slowTraceId", this.slowTraceId.getAndSet(null));
        row.put((Object)"errorTraceId", this.errorTraceId.getAndSet(null));
        row.put((Object)"queryRowCount", (Object)this.queryRowCount.getAndSet(0L));
        row.put((Object)"updateRowCount", (Object)this.updateRowCount.getAndSet(0L));
        return row;
    }
}

