/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.hbase.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.plugin.hbase.HBaseUtils;
import com.lubanops.apm.plugin.hbase.collector.HBaseCollector;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Result;

public class MutationInterceptor
implements Interceptor {
    private final ThreadLocal<Boolean> hasErrorLocal = new ThreadLocal();

    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            if (HBaseCollector.INSTANCE.isEnable()) {
                HTable table = (HTable)object;
                String tableNameWithNamespace = HBaseUtils.getTableNameWithNamespace(table);
                Mutation mutation = (Mutation)args[0];
                String parsedMutation = HBaseUtils.parseMutation(mutation);
                HBaseCollector.onStart(tableNameWithNamespace, parsedMutation);
                SpanEvent spanEvent = TraceCollector.onStart((String)className, (String)methodName, (String)"HBase");
                if (spanEvent != null) {
                    spanEvent.addTag("Table Name", tableNameWithNamespace);
                    spanEvent.addTag("Command", parsedMutation);
                }
            }
        }
        catch (Exception mutationException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)mutationException);
        }
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        try {
            if (HBaseCollector.INSTANCE.isEnable()) {
                this.hasErrorLocal.set(Boolean.TRUE);
                TraceCollector.onError((Throwable)e);
                HBaseCollector.onRequestError(TraceCollector.getTraceId());
                HBaseCollector.onException(e);
            }
        }
        catch (Exception mutationException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)mutationException);
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            if (HBaseCollector.INSTANCE.isEnable()) {
                Boolean hasError;
                SpanEvent spanEvent = TraceCollector.getSpanEvent();
                if (result instanceof Result && !((Result)result).isEmpty()) {
                    HBaseCollector.incrementQueryRowCount(1L);
                    if (spanEvent != null) {
                        spanEvent.addTag("Rows Queried", "1");
                    }
                }
                if ((hasError = this.hasErrorLocal.get()) == null || hasError.equals(Boolean.FALSE)) {
                    HBaseCollector.incrementUpdateRowCount(1L);
                    if (spanEvent != null) {
                        spanEvent.addTag("Rows Updated", "1");
                    }
                }
                HBaseCollector.onFinally();
                TraceCollector.onFinally();
                this.hasErrorLocal.set(Boolean.FALSE);
            }
        }
        catch (Exception mutationException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)mutationException);
        }
    }
}

