/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.cse.interceptor;

import com.lubanops.apm.bootstrap.config.IdentityConfigManager;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.otel.OtelSpanKind;
import com.lubanops.apm.bootstrap.trace.Headers;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.bootstrap.utils.StringUtils;
import com.lubanops.apm.plugin.cse.collector.consumer.CSEConsumerCollector;
import com.lubanops.apm.plugin.cse.interceptor.Handler;
import com.lubanops.apm.plugin.cse.utils.CSEUtils;
import io.opentelemetry.api.trace.Span;
import java.util.Map;
import org.apache.servicecomb.common.rest.definition.RestOperationMeta;
import org.apache.servicecomb.core.Endpoint;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.event.InvocationBusinessMethodFinishEvent;
import org.apache.servicecomb.core.event.InvocationBusinessMethodStartEvent;
import org.apache.servicecomb.core.event.InvocationFinishEvent;
import org.apache.servicecomb.core.event.InvocationStartEvent;

public class ConsumerHandler
implements Handler {
    @Override
    public void onInvocationStart(InvocationStartEvent event) {
        try {
            if (CSEConsumerCollector.INSTANCE.isEnable()) {
                String userFlag;
                String gTraceId;
                Invocation invocation = event.getInvocation();
                RestOperationMeta restOperationMeta = (RestOperationMeta)invocation.getOperationMeta().getExtData("swaggerRestOperation");
                String httpMethod = invocation.getOperationMeta().getHttpMethod();
                CSEConsumerCollector.onStart(restOperationMeta.getAbsolutePath(), httpMethod);
                Map<String, Object> map = CSEConsumerCollector.getThreadLocalMap();
                invocation.addLocalContext("lubanopsapmThreadLocalMap", map);
                CSEConsumerCollector.clearThreadLocal();
                SpanEvent spanEvent = TraceCollector.onStart((String)"CSE", (String)invocation.getInvocationQualifiedName(), (String)"CSE", (String)httpMethod, (String)OtelSpanKind.CLIENT.name());
                if (spanEvent != null) {
                    String w3CHeader;
                    spanEvent.addTag("url", restOperationMeta.getAbsolutePath());
                    spanEvent.addTag("httpMethod", httpMethod);
                    String nextSpanId = spanEvent.generateNextSpanId();
                    spanEvent.setNextSpanId(nextSpanId);
                    invocation.addContext(Headers.TRACE_ID.getValue(), spanEvent.getTraceId());
                    invocation.addContext(Headers.SPAN_ID.getValue(), nextSpanId);
                    invocation.addContext(Headers.SOURCE_EVENT_ID.getValue(), spanEvent.getEventId());
                    if (spanEvent.hasSamplingPolicy()) {
                        invocation.addContext(Headers.POLICY_ID.getValue(), spanEvent.getPolicyId());
                    }
                    if ((w3CHeader = TraceCollector.getW3CHeader((Span)spanEvent.getOtelSpan())) != null) {
                        invocation.addContext(Headers.OTEL_HEADER.getValue(), w3CHeader);
                    }
                    Span otelSpan = spanEvent.getOtelSpan();
                    TraceCollector.addOtelAttribute((Span)otelSpan, (String)"http.method", (Object)httpMethod);
                    TraceCollector.addOtelAttribute((Span)otelSpan, (String)"http.url", (Object)restOperationMeta.getAbsolutePath());
                }
                if (!StringUtils.isBlank((String)(gTraceId = TraceCollector.getVirtualTraceId()))) {
                    invocation.addContext(Headers.GTRACE_ID.getValue(), gTraceId);
                }
                if (!StringUtils.isBlank((String)(userFlag = TraceCollector.getUserFlag()))) {
                    invocation.addContext(Headers.USER_FLAG.getValue(), userFlag);
                }
                invocation.addContext(Headers.ENV_ID.getValue(), String.valueOf(IdentityConfigManager.getEnvId()));
                invocation.addContext(Headers.DOMAIN_ID.getValue(), String.valueOf(IdentityConfigManager.getDomainId()));
                invocation.addContext(Headers.DOMAIN_TYPE.getValue(), String.valueOf(IdentityConfigManager.getDomainType()));
                invocation.addLocalContext("lubanopsapmSpanEvent", (Object)spanEvent);
                TraceCollector.onFinally((boolean)false);
            }
        }
        catch (Throwable e1) {
            LogFactory.getLogger().log(Level.SEVERE, "", e1);
        }
    }

    @Override
    public void onInvocationFinish(InvocationFinishEvent event) {
        try {
            if (CSEConsumerCollector.INSTANCE.isEnable()) {
                int code = event.getResponse().getStatusCode();
                Invocation invocation = event.getInvocation();
                Map map = (Map)invocation.getLocalContext("lubanopsapmThreadLocalMap");
                invocation.addLocalContext("lubanopsapmThreadLocalMap", null);
                CSEConsumerCollector.setThreadLocalMap(map);
                String envId = this.getEnvId(invocation);
                CSEConsumerCollector.onFinally(code, envId);
                SpanEvent spanEvent = (SpanEvent)invocation.getLocalContext("lubanopsapmSpanEvent");
                if (spanEvent != null) {
                    CSEUtils.toStringInvocationStageTrace(invocation.getInvocationStageTrace(), spanEvent);
                    invocation.addLocalContext("lubanopsapmSpanEvent", null);
                    long endTime = System.nanoTime();
                    long timeUsed = endTime - spanEvent.getStartNanoTime();
                    spanEvent.setTimeUsed(timeUsed);
                    spanEvent.addTag("code", String.valueOf(code));
                    TraceCollector.addOtelAttribute((String)"http.status_code", (Object)String.valueOf(code));
                    if (code >= 400) {
                        spanEvent.setHasError(true);
                    }
                    TraceCollector.sendSpanEvent((SpanEvent)spanEvent);
                }
            }
        }
        catch (Throwable e1) {
            LogFactory.getLogger().log(Level.SEVERE, "", e1);
        }
    }

    private String getEnvId(Invocation invocation) {
        String envId = null;
        try {
            Map properties;
            Endpoint endpoint = invocation.getEndpoint();
            if (endpoint != null && endpoint.getMicroserviceInstance() != null && (properties = endpoint.getMicroserviceInstance().getProperties()) != null) {
                envId = (String)properties.get("lopsClusterId");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return envId;
    }

    @Override
    public void onInvocationBusinessFinish(InvocationBusinessMethodFinishEvent event) {
    }

    @Override
    public void onInvocationBusinessStart(InvocationBusinessMethodStartEvent event) {
    }
}

