/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.reactornetty.client.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.log.Logger;
import com.lubanops.apm.bootstrap.trace.Headers;
import io.netty.handler.codec.http.HttpHeaders;
import java.util.HashMap;
import java.util.Map;

public class DefaultHttpHeadersInterceptor
implements Interceptor {
    private static final Logger LOGGER = LogFactory.getLogger();
    private final HashMap<String, String> addHeaders = new HashMap();

    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        HttpHeaders oldHeaders = (HttpHeaders)object;
        if (!oldHeaders.isEmpty()) {
            String otelHeader;
            String policyId;
            String envId;
            String txName;
            String userFlag;
            String gtraceId;
            String traceId = oldHeaders.get(Headers.TRACE_ID.getValue());
            if (traceId != null) {
                this.addHeaders.put(Headers.TRACE_ID.getValue(), traceId);
                this.addHeaders.put(Headers.SPAN_ID.getValue(), oldHeaders.get(Headers.SPAN_ID.getValue()));
                this.addHeaders.put(Headers.SOURCE_EVENT_ID.getValue(), oldHeaders.get(Headers.SOURCE_EVENT_ID.getValue()));
            }
            if ((gtraceId = oldHeaders.get(Headers.GTRACE_ID.getValue())) != null) {
                this.addHeaders.put(Headers.GTRACE_ID.getValue(), gtraceId);
            }
            if ((userFlag = oldHeaders.get(Headers.USER_FLAG.getValue())) != null) {
                this.addHeaders.put(Headers.USER_FLAG.getValue(), userFlag);
            }
            if ((txName = oldHeaders.get(Headers.TXNANE_ID.getValue())) != null) {
                this.addHeaders.put(Headers.TXNANE_ID.getValue(), txName);
            }
            if ((envId = oldHeaders.get(Headers.ENV_ID.getValue())) != null) {
                this.addHeaders.put(Headers.ENV_ID.getValue(), envId);
                this.addHeaders.put(Headers.DOMAIN_ID.getValue(), oldHeaders.get(Headers.DOMAIN_ID.getValue()));
                this.addHeaders.put(Headers.DOMAIN_TYPE.getValue(), oldHeaders.get(Headers.DOMAIN_TYPE.getValue()));
            }
            if ((policyId = oldHeaders.get(Headers.POLICY_ID.getValue())) != null) {
                this.addHeaders.put(Headers.POLICY_ID.getValue(), policyId);
            }
            if ((otelHeader = oldHeaders.get(Headers.OTEL_HEADER.getValue())) != null) {
                this.addHeaders.put(Headers.OTEL_HEADER.getValue(), otelHeader);
            }
        }
        return null;
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        if (!this.addHeaders.isEmpty()) {
            HttpHeaders headers = (HttpHeaders)result;
            for (Map.Entry<String, String> entry : this.addHeaders.entrySet()) {
                headers.set(entry.getKey(), (Object)entry.getValue());
            }
            this.addHeaders.clear();
        }
    }
}

