/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.kafka.consumer;

import com.lubanops.apm.bootstrap.AttributeAccess;
import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.plugin.kafka.collector.KafkaConsumerCollector;
import com.lubanops.apm.bootstrap.plugin.kafka.collector.KafkaSampleFilter;
import com.lubanops.apm.bootstrap.trace.Headers;
import com.lubanops.apm.bootstrap.trace.SampleFilter;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.StartTraceRequest;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.bootstrap.utils.StringUtils;
import java.util.Iterator;
import java.util.List;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.common.header.Header;
import org.springframework.kafka.listener.adapter.HandlerAdapter;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;

public class KafkaConsumerInvokeInterceptor
implements Interceptor {
    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        if (KafkaConsumerCollector.INSTANCE.isEnable()) {
            Object[] fileds;
            String source = className + "." + methodName;
            if ("org/springframework/kafka/listener/adapter/MessagingMessageListenerAdapter".equals(className) && object instanceof AttributeAccess && (fileds = ((AttributeAccess)object).getLopsFileds()).length > 0 && fileds[0] instanceof HandlerAdapter) {
                HandlerAdapter handlerAdapter = (HandlerAdapter)fileds[0];
                if (args.length > 2 && args[2] instanceof Message) {
                    Message message = (Message)args[2];
                    source = handlerAdapter.getMethodAsString(message.getPayload());
                    MessageHeaders messageHeaders = message.getHeaders();
                }
            }
            KafkaConsumerCollector.onStart((String)source);
            String traceIds = this.getTraceIds(args);
            StartTraceRequest startTraceRequest = new StartTraceRequest(className, methodName, null, null, null);
            startTraceRequest.setKind("KafkaConsumer");
            startTraceRequest.setSource(source);
            startTraceRequest.setRealSource(source);
            startTraceRequest.setSampleFilter((SampleFilter)new KafkaSampleFilter());
            SpanEvent spanEvent = TraceCollector.onStart((StartTraceRequest)startTraceRequest);
            if (!StringUtils.isBlank((String)traceIds) && spanEvent != null) {
                spanEvent.addTag("traceIds", traceIds);
            }
        }
        return null;
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        if (KafkaConsumerCollector.INSTANCE.isEnable()) {
            KafkaConsumerCollector.onError();
            KafkaConsumerCollector.onError((Throwable)e);
            TraceCollector.onError((Throwable)e);
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        if (KafkaConsumerCollector.INSTANCE.isEnable()) {
            KafkaConsumerCollector.onFinally();
            TraceCollector.onFinally((int)200);
        }
        KafkaConsumerCollector.clearErrorContext();
    }

    private String getTraceIds(Object[] args) {
        StringBuilder result = new StringBuilder();
        int limitCount = 50;
        for (Object arg : args) {
            if (arg instanceof ConsumerRecord) {
                this.resolveConsumerRecord(arg, result);
                return result.toString();
            }
            if (arg instanceof ConsumerRecords) {
                this.resolveConsumerRecords(arg, result, limitCount);
                return result.toString();
            }
            if (!(arg instanceof List) || ((List)arg).size() <= 0 || !(((List)arg).get(0) instanceof ConsumerRecords)) continue;
            this.resolveConsumerRecordList(arg, result, limitCount);
            return result.toString();
        }
        return null;
    }

    private void resolveConsumerRecord(Object arg, StringBuilder result) {
        ConsumerRecord cr = (ConsumerRecord)arg;
        String traceId = this.getValue(cr, Headers.TRACE_ID.getValue());
        String spanId = this.getValue(cr, Headers.SPAN_ID.getValue());
        String gtraceId = this.getValue(cr, Headers.GTRACE_ID.getValue());
        result.append(gtraceId);
        if (!StringUtils.isBlank((String)traceId)) {
            result.append("|").append(traceId).append("|").append(spanId);
        }
    }

    private void resolveConsumerRecordList(Object arg, StringBuilder result, int limitCount) {
        List consumerRecords = (List)arg;
        for (int i = 0; i < consumerRecords.size(); ++i) {
            if (i > limitCount) {
                result.append("...(" + consumerRecords.size() + ")");
                break;
            }
            Object obj = consumerRecords.get(i);
            if (!(obj instanceof ConsumerRecord)) continue;
            ConsumerRecord crecord = (ConsumerRecord)obj;
            String traceId = this.getValue(crecord, Headers.TRACE_ID.getValue());
            String spanId = this.getValue(crecord, Headers.SPAN_ID.getValue());
            String gtraceId = this.getValue(crecord, Headers.GTRACE_ID.getValue());
            result.append(gtraceId);
            if (!StringUtils.isBlank((String)traceId)) {
                result.append("|").append(traceId).append("|").append(spanId);
            }
            if (StringUtils.isBlank((String)gtraceId)) continue;
            result.append(";");
        }
    }

    private void resolveConsumerRecords(Object arg, StringBuilder result, int limitCount) {
        ConsumerRecords consumerRecords = (ConsumerRecords)arg;
        Iterator it = consumerRecords.iterator();
        int count = 0;
        while (it.hasNext()) {
            if (++count > limitCount) {
                result.append("...(" + consumerRecords.count() + ")");
                break;
            }
            ConsumerRecord cr = (ConsumerRecord)it.next();
            String traceId = this.getValue(cr, Headers.TRACE_ID.getValue());
            String spanId = this.getValue(cr, Headers.SPAN_ID.getValue());
            String gtraceId = this.getValue(cr, Headers.GTRACE_ID.getValue());
            result.append(gtraceId);
            if (!StringUtils.isBlank((String)traceId)) {
                result.append("|").append(traceId).append("|").append(spanId);
            }
            if (StringUtils.isBlank((String)gtraceId)) continue;
            result.append(";");
        }
    }

    private String getValue(ConsumerRecord cr, String key) {
        try {
            org.apache.kafka.common.header.Headers headers = cr.headers();
            Header header = headers.lastHeader(key);
            if (header != null) {
                return new String(header.value(), "UTF-8");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }
}

