/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.jettyclient.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.TransformAccess;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.plugin.httpclient.collector.HttpClientCollector;
import com.lubanops.apm.bootstrap.trace.Headers;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.plugin.jettyclient.JettyClientUtils;
import java.util.Map;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.HttpRequest;

public class ResponseCompleteInterceptor
implements Interceptor {
    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            HttpExchange httpExchange;
            HttpRequest request;
            if (HttpClientCollector.INSTANCE.isEnable() && (request = JettyClientUtils.getRequest(httpExchange = (HttpExchange)object)) instanceof TransformAccess) {
                int code = httpExchange.getResponse().getStatus();
                Throwable failure = (Throwable)args[0];
                String envId = request.getHeaders().get(Headers.ENV_ID.getValue());
                Map context = (Map)((TransformAccess)request).getLopsAttribute();
                String url = (String)context.get("url");
                SpanEvent spanEvent = (SpanEvent)context.get("spanevent");
                String traceId = null;
                if (spanEvent != null) {
                    traceId = spanEvent.getTraceId();
                    spanEvent.addTag("code", String.valueOf(code));
                }
                if (failure != null) {
                    TraceCollector.onError((SpanEvent)spanEvent, (Throwable)failure);
                    HttpClientCollector.onThrowableAsync((Throwable)failure, (Map)context, (String)traceId);
                }
                HttpClientCollector.onResponseCloseAsync((String)envId, (Map)context, (String)traceId);
                HttpClientCollector.onStatusCodeAsync((String)url, (int)code, (Map)context, (String)traceId);
                if (spanEvent != null) {
                    TraceCollector.onFinallySpanEvent((SpanEvent)spanEvent);
                }
            }
        }
        catch (Exception e1) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)e1);
        }
    }
}

