/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.text.ui;

import com.taobao.text.LineRenderer;
import com.taobao.text.ui.RowElement;
import com.taobao.text.ui.RowLineRenderer;
import com.taobao.text.ui.TableLineRenderer;
import com.taobao.text.ui.TableRowReader;
import java.util.List;

class TableRowLineRenderer {
    final TableLineRenderer table;
    final RowLineRenderer row;
    final boolean header;
    private TableRowLineRenderer previous;
    private TableRowLineRenderer next;
    private int index;

    TableRowLineRenderer(TableLineRenderer table, RowElement row) {
        this.table = table;
        this.row = new RowLineRenderer(row, table.separator, table.leftCellPadding, table.rightCellPadding);
        this.header = row.header;
        this.index = 0;
    }

    TableRowLineRenderer add(TableRowLineRenderer next) {
        next.previous = this;
        next.index = this.index + 1;
        this.next = next;
        return next;
    }

    boolean hasTop() {
        return this.header && this.previous != null;
    }

    boolean hasBottom() {
        return this.header && this.next != null && !this.next.header;
    }

    int getIndex() {
        return this.index;
    }

    int getSize() {
        return this.index + 1;
    }

    TableRowLineRenderer previous() {
        return this.previous;
    }

    TableRowLineRenderer next() {
        return this.next;
    }

    boolean isHeader() {
        return this.header;
    }

    int getColsSize() {
        return this.row.getSize();
    }

    List<LineRenderer> getCols() {
        return this.row.getCols();
    }

    int getActualWidth() {
        return this.row.getActualWidth();
    }

    int getMinWidth() {
        return this.row.getMinWidth();
    }

    int getActualHeight(int width) {
        int actualHeight;
        switch (this.table.overflow) {
            case HIDDEN: {
                actualHeight = 1;
                break;
            }
            case WRAP: {
                actualHeight = this.row.getActualHeight(width);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        if (this.hasTop()) {
            ++actualHeight;
        }
        if (this.hasBottom()) {
            ++actualHeight;
        }
        return actualHeight;
    }

    int getActualHeight(int[] widths) {
        int actualHeight;
        switch (this.table.overflow) {
            case HIDDEN: {
                actualHeight = 1;
                break;
            }
            case WRAP: {
                actualHeight = 0;
                for (int i = 0; i < widths.length; ++i) {
                    LineRenderer col = this.row.getCols().get(i);
                    actualHeight = Math.max(actualHeight, col.getActualHeight(widths[i]));
                }
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        if (this.hasTop()) {
            ++actualHeight;
        }
        if (this.hasBottom()) {
            ++actualHeight;
        }
        return actualHeight;
    }

    int getMinHeight(int[] widths) {
        int minHeight;
        switch (this.table.overflow) {
            case HIDDEN: {
                minHeight = 1;
                break;
            }
            case WRAP: {
                minHeight = 0;
                for (int i = 0; i < widths.length; ++i) {
                    LineRenderer col = this.row.getCols().get(i);
                    minHeight = Math.max(minHeight, col.getMinHeight(widths[i]));
                }
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        if (this.hasTop()) {
            ++minHeight;
        }
        if (this.hasBottom()) {
            ++minHeight;
        }
        return minHeight;
    }

    TableRowReader renderer(int[] widths, int height) {
        return new TableRowReader(this, this.row, widths, height);
    }
}

