/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.shade.com.cloud.sdk;

import com.huawei.shade.com.cloud.sdk.RequestClientOptions;
import com.huawei.shade.com.cloud.sdk.auth.credentials.Credentials;
import com.huawei.shade.org.apache.http.annotation.NotThreadSafe;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@NotThreadSafe
public abstract class WebServiceRequest
implements Cloneable {
    public static final WebServiceRequest NOOP = new WebServiceRequest(){};
    private final RequestClientOptions requestClientOptions = new RequestClientOptions();
    private Credentials credentials;
    private Map<String, String> customRequestHeaders;

    public void setRequestCredentials(Credentials credentials) {
        this.credentials = credentials;
    }

    public Credentials getRequestCredentials() {
        return this.credentials;
    }

    public Map<String, String> copyPrivateRequestParameters() {
        return new HashMap<String, String>();
    }

    public RequestClientOptions getRequestClientOptions() {
        return this.requestClientOptions;
    }

    public Map<String, String> getCustomRequestHeaders() {
        if (this.customRequestHeaders == null) {
            return null;
        }
        return Collections.unmodifiableMap(this.customRequestHeaders);
    }

    public String putCustomRequestHeader(String name, String value) {
        if (this.customRequestHeaders == null) {
            this.customRequestHeaders = new HashMap<String, String>();
        }
        return this.customRequestHeaders.put(name, value);
    }

    public final int getReadLimit() {
        return this.requestClientOptions.getReadLimit();
    }

    protected final <T extends WebServiceRequest> T copyBaseTo(T target) {
        if (this.customRequestHeaders != null) {
            for (Map.Entry<String, String> e : this.customRequestHeaders.entrySet()) {
                target.putCustomRequestHeader(e.getKey(), e.getValue());
            }
        }
        target.setRequestCredentials(this.credentials);
        this.requestClientOptions.copyTo(target.getRequestClientOptions());
        return target;
    }

    public WebServiceRequest clone() {
        try {
            return (WebServiceRequest)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

