/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.plugin.sql.collector;

import com.lubanops.apm.bootstrap.config.AgentConfigManager;
import com.lubanops.apm.bootstrap.config.ConfigManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class SqlStatsConfig {
    public static final int DEFAULT_ROWS_NUM = 100;
    public static final int DEFAULT_VALUE_SIZE = 999;
    public static final int DEFAULT_SQL_SIZE = 2000;
    public static final int MAX_SQL_SIZE = 4096;
    private boolean parseOriginSql = false;
    private boolean bodyDetail = false;
    private int rowsNum = 100;
    private int valueSize = 999;
    private List<String> shardTableNames = new ArrayList<String>();
    private int sqlSize = 2000;
    private Integer slowSqlThreshold = null;

    public void setBodyDetail(Boolean bodyDetail) {
        this.bodyDetail = bodyDetail == null ? false : bodyDetail;
    }

    public void setRowsNum(Integer rowsNum) {
        this.rowsNum = rowsNum == null || rowsNum < 0 ? 100 : rowsNum;
    }

    public void setValueSize(Integer valueSize) {
        this.valueSize = valueSize == null || valueSize < 0 ? 999 : valueSize;
    }

    public void setSqlSize(Integer sqlSize) {
        this.sqlSize = sqlSize == null || sqlSize < 0 || sqlSize > 4096 ? 2000 : sqlSize;
    }

    public boolean isBodyDetail() {
        if (AgentConfigManager.isCollectSQLResult()) {
            return true;
        }
        return this.bodyDetail;
    }

    public int getRowsNum() {
        return this.rowsNum;
    }

    public void setRowsNum(int rowsNum) {
        this.rowsNum = rowsNum;
    }

    public int getValueSize() {
        return this.valueSize;
    }

    public void setValueSize(int valueSize) {
        this.valueSize = valueSize;
    }

    public int getSqlSize() {
        return this.sqlSize;
    }

    public boolean isParseOriginSql() {
        return this.parseOriginSql;
    }

    public void setParseOriginSql(Boolean parseOriginSql) {
        this.parseOriginSql = parseOriginSql == null ? false : parseOriginSql;
    }

    public List<String> getShardTableNames() {
        return this.shardTableNames;
    }

    public void setShardTableNames(List<String> shardTableNames) {
        if (shardTableNames == null) {
            shardTableNames = new ArrayList<String>();
        }
        Collections.sort(shardTableNames, new ShardTableComparator());
        this.shardTableNames = shardTableNames;
    }

    public int getSlowSqlThreshold() {
        if (this.slowSqlThreshold == null) {
            return ConfigManager.getSlowSqlThreshold();
        }
        return this.slowSqlThreshold;
    }

    public void setSlowSqlThreshold(Integer slowSqlThreshold) {
        if (slowSqlThreshold == null) {
            this.slowSqlThreshold = null;
        } else {
            if (slowSqlThreshold > 20000 || slowSqlThreshold < 100) {
                slowSqlThreshold = 800;
            }
            this.slowSqlThreshold = slowSqlThreshold;
        }
    }

    class ShardTableComparator
    implements Comparator<String> {
        ShardTableComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            if (o1.length() > o2.length()) {
                return 1;
            }
            if (o1.length() < o2.length()) {
                return -1;
            }
            return 0;
        }
    }
}

