/*
 * Decompiled with CFR 0.152.
 */
package one.proto;

import java.util.Arrays;

public class Proto {
    private byte[] buf;
    private int pos;

    public Proto(int n) {
        this.buf = new byte[n];
    }

    public byte[] buffer() {
        return this.buf;
    }

    public int size() {
        return this.pos;
    }

    public void reset() {
        this.pos = 0;
    }

    public Proto field(int n, int n2) {
        this.tag(n, 0);
        this.writeInt(n2);
        return this;
    }

    public Proto field(int n, long l) {
        this.tag(n, 0);
        this.writeLong(l);
        return this;
    }

    public Proto field(int n, double d) {
        this.tag(n, 1);
        this.writeDouble(d);
        return this;
    }

    public Proto field(int n, String string) {
        this.tag(n, 2);
        this.writeString(string);
        return this;
    }

    public Proto field(int n, byte[] byArray) {
        this.tag(n, 2);
        this.writeBytes(byArray, 0, byArray.length);
        return this;
    }

    public Proto field(int n, Proto proto) {
        this.tag(n, 2);
        this.writeBytes(proto.buf, 0, proto.pos);
        return this;
    }

    public void writeInt(int n) {
        int n2 = n == 0 ? 1 : (38 - Integer.numberOfLeadingZeros(n)) / 7;
        this.ensureCapacity(n2);
        while (n > 127) {
            this.buf[this.pos++] = (byte)(0x80 | n & 0x7F);
            n >>>= 7;
        }
        this.buf[this.pos++] = (byte)n;
    }

    public void writeLong(long l) {
        int n = l == 0L ? 1 : (70 - Long.numberOfLeadingZeros(l)) / 7;
        this.ensureCapacity(n);
        while (l > 127L) {
            this.buf[this.pos++] = (byte)(0x80L | l & 0x7FL);
            l >>>= 7;
        }
        this.buf[this.pos++] = (byte)l;
    }

    public void writeDouble(double d) {
        this.ensureCapacity(8);
        long l = Double.doubleToRawLongBits(d);
        this.buf[this.pos] = (byte)l;
        this.buf[this.pos + 1] = (byte)(l >>> 8);
        this.buf[this.pos + 2] = (byte)(l >>> 16);
        this.buf[this.pos + 3] = (byte)(l >>> 24);
        this.buf[this.pos + 4] = (byte)(l >>> 32);
        this.buf[this.pos + 5] = (byte)(l >>> 40);
        this.buf[this.pos + 6] = (byte)(l >>> 48);
        this.buf[this.pos + 7] = (byte)(l >>> 56);
        this.pos += 8;
    }

    public void writeString(String string) {
        int n = string.length();
        this.writeInt(n);
        this.ensureCapacity(n);
        for (int i = 0; i < n; ++i) {
            this.buf[this.pos++] = (byte)string.charAt(i);
        }
    }

    public void writeBytes(byte[] byArray, int n, int n2) {
        this.writeInt(n2);
        this.ensureCapacity(n2);
        System.arraycopy(byArray, n, this.buf, this.pos, n2);
        this.pos += n2;
    }

    private void tag(int n, int n2) {
        this.ensureCapacity(1);
        this.buf[this.pos++] = (byte)(n << 3 | n2);
    }

    private void ensureCapacity(int n) {
        if (this.pos + n > this.buf.length) {
            this.buf = Arrays.copyOf(this.buf, Math.max(this.pos + n, this.buf.length * 2));
        }
    }
}

