/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bytekit.asm.location;

import com.alibaba.bytekit.asm.MethodProcessor;
import com.alibaba.bytekit.asm.binding.BindingContext;
import com.alibaba.bytekit.asm.binding.StackSaver;
import com.alibaba.bytekit.asm.location.LocationType;
import com.alibaba.bytekit.asm.location.MethodInsnNodeWare;
import com.alibaba.bytekit.utils.AsmOpUtils;
import com.alibaba.bytekit.utils.AsmUtils;
import com.alibaba.deps.org.objectweb.asm.Type;
import com.alibaba.deps.org.objectweb.asm.tree.AbstractInsnNode;
import com.alibaba.deps.org.objectweb.asm.tree.FieldInsnNode;
import com.alibaba.deps.org.objectweb.asm.tree.InsnList;
import com.alibaba.deps.org.objectweb.asm.tree.LocalVariableNode;
import com.alibaba.deps.org.objectweb.asm.tree.MethodInsnNode;

public abstract class Location {
    AbstractInsnNode insnNode;
    boolean whenComplete = false;
    boolean stackNeedSave = false;
    public static final int ACCESS_READ = 1;
    public static final int ACCESS_WRITE = 2;

    public Location(AbstractInsnNode insnNode) {
        this(insnNode, false);
    }

    public Location(AbstractInsnNode insnNode, boolean whenComplete) {
        this.insnNode = insnNode;
        this.whenComplete = whenComplete;
    }

    public boolean isWhenComplete() {
        return this.whenComplete;
    }

    public AbstractInsnNode getInsnNode() {
        return this.insnNode;
    }

    public boolean canChangeByReturn() {
        return false;
    }

    public boolean isStackNeedSave() {
        return this.stackNeedSave;
    }

    public StackSaver getStackSaver() {
        throw new UnsupportedOperationException("this location do not StackSaver, type:" + (Object)((Object)this.getLocationType()));
    }

    public abstract LocationType getLocationType();

    public static class InvokeExceptionExitLocation
    extends Location
    implements MethodInsnNodeWare {
        private MethodInsnNode methodInsnNode;

        public InvokeExceptionExitLocation(MethodInsnNode methodInsnNode, AbstractInsnNode insnNode) {
            super(insnNode, true);
            this.stackNeedSave = true;
            this.methodInsnNode = methodInsnNode;
        }

        @Override
        public LocationType getLocationType() {
            return LocationType.INVOKE_EXCEPTION_EXIT;
        }

        @Override
        public StackSaver getStackSaver() {
            StackSaver stackSaver = new StackSaver(){

                @Override
                public void store(InsnList instructions, BindingContext bindingContext) {
                    LocalVariableNode throwVariableNode = bindingContext.getMethodProcessor().initThrowVariableNode();
                    AsmOpUtils.storeVar(instructions, Type.getType(Throwable.class), throwVariableNode.index);
                }

                @Override
                public void load(InsnList instructions, BindingContext bindingContext) {
                    LocalVariableNode throwVariableNode = bindingContext.getMethodProcessor().initThrowVariableNode();
                    AsmOpUtils.loadVar(instructions, Type.getType(Throwable.class), throwVariableNode.index);
                }

                @Override
                public Type getType(BindingContext bindingContext) {
                    return Type.getType(Throwable.class);
                }
            };
            return stackSaver;
        }

        @Override
        public MethodInsnNode methodInsnNode() {
            return this.methodInsnNode;
        }
    }

    public static class ExceptionExitLocation
    extends Location {
        public ExceptionExitLocation(AbstractInsnNode insnNode) {
            super(insnNode, true);
            this.stackNeedSave = true;
        }

        @Override
        public LocationType getLocationType() {
            return LocationType.EXCEPTION_EXIT;
        }

        @Override
        public StackSaver getStackSaver() {
            StackSaver stackSaver = new StackSaver(){

                @Override
                public void store(InsnList instructions, BindingContext bindingContext) {
                    LocalVariableNode throwVariableNode = bindingContext.getMethodProcessor().initThrowVariableNode();
                    AsmOpUtils.storeVar(instructions, Type.getType(Throwable.class), throwVariableNode.index);
                }

                @Override
                public void load(InsnList instructions, BindingContext bindingContext) {
                    LocalVariableNode throwVariableNode = bindingContext.getMethodProcessor().initThrowVariableNode();
                    AsmOpUtils.loadVar(instructions, Type.getType(Throwable.class), throwVariableNode.index);
                }

                @Override
                public Type getType(BindingContext bindingContext) {
                    return Type.getType(Throwable.class);
                }
            };
            return stackSaver;
        }
    }

    public static class ExitLocation
    extends Location {
        public ExitLocation(AbstractInsnNode insnNode) {
            super(insnNode);
            this.stackNeedSave = true;
        }

        @Override
        public boolean canChangeByReturn() {
            return true;
        }

        @Override
        public LocationType getLocationType() {
            return LocationType.EXIT;
        }

        @Override
        public StackSaver getStackSaver() {
            StackSaver stackSaver = new StackSaver(){

                @Override
                public void store(InsnList instructions, BindingContext bindingContext) {
                    Type returnType = bindingContext.getMethodProcessor().getReturnType();
                    if (!returnType.equals((Object)Type.VOID_TYPE)) {
                        LocalVariableNode returnVariableNode = bindingContext.getMethodProcessor().initReturnVariableNode();
                        AsmOpUtils.storeVar(instructions, returnType, returnVariableNode.index);
                    }
                }

                @Override
                public void load(InsnList instructions, BindingContext bindingContext) {
                    Type returnType = bindingContext.getMethodProcessor().getReturnType();
                    if (!returnType.equals((Object)Type.VOID_TYPE)) {
                        LocalVariableNode returnVariableNode = bindingContext.getMethodProcessor().initReturnVariableNode();
                        AsmOpUtils.loadVar(instructions, returnType, returnVariableNode.index);
                    }
                }

                @Override
                public Type getType(BindingContext bindingContext) {
                    return bindingContext.getMethodProcessor().getReturnType();
                }
            };
            return stackSaver;
        }
    }

    public static class ThrowLocation
    extends Location {
        private int count;

        public ThrowLocation(AbstractInsnNode insnNode, int count) {
            super(insnNode);
            this.count = count;
            this.stackNeedSave = true;
        }

        @Override
        public boolean canChangeByReturn() {
            return true;
        }

        @Override
        public LocationType getLocationType() {
            return LocationType.THROW;
        }

        @Override
        public StackSaver getStackSaver() {
            StackSaver stackSaver = new StackSaver(){

                @Override
                public void store(InsnList instructions, BindingContext bindingContext) {
                    LocalVariableNode throwVariableNode = bindingContext.getMethodProcessor().initThrowVariableNode();
                    AsmOpUtils.storeVar(instructions, Type.getType(Throwable.class), throwVariableNode.index);
                }

                @Override
                public void load(InsnList instructions, BindingContext bindingContext) {
                    LocalVariableNode throwVariableNode = bindingContext.getMethodProcessor().initThrowVariableNode();
                    AsmOpUtils.loadVar(instructions, Type.getType(Throwable.class), throwVariableNode.index);
                }

                @Override
                public Type getType(BindingContext bindingContext) {
                    return Type.getType(Throwable.class);
                }
            };
            return stackSaver;
        }
    }

    public static class SyncExitLocation
    extends Location {
        private int count;

        public SyncExitLocation(AbstractInsnNode insnNode, int count, boolean whenComplete) {
            super(insnNode, whenComplete);
            this.count = count;
            this.whenComplete = whenComplete;
            this.stackNeedSave = !whenComplete;
        }

        @Override
        public LocationType getLocationType() {
            if (this.whenComplete) {
                return LocationType.SYNC_ENTER_COMPLETED;
            }
            return LocationType.SYNC_ENTER;
        }

        @Override
        public StackSaver getStackSaver() {
            return new StackSaver(){

                @Override
                public void store(InsnList instructions, BindingContext bindingContext) {
                    LocalVariableNode variableNode = bindingContext.getMethodProcessor().initMonitorVariableNode();
                    AsmOpUtils.storeVar(instructions, AsmOpUtils.OBJECT_TYPE, variableNode.index);
                }

                @Override
                public void load(InsnList instructions, BindingContext bindingContext) {
                    LocalVariableNode variableNode = bindingContext.getMethodProcessor().initMonitorVariableNode();
                    AsmOpUtils.loadVar(instructions, AsmOpUtils.OBJECT_TYPE, variableNode.index);
                }

                @Override
                public Type getType(BindingContext bindingContext) {
                    return AsmOpUtils.OBJECT_TYPE;
                }
            };
        }
    }

    public static class SyncEnterLocation
    extends Location {
        private int count;

        public SyncEnterLocation(AbstractInsnNode insnNode, int count, boolean whenComplete) {
            super(insnNode, whenComplete);
            this.count = count;
            this.whenComplete = whenComplete;
            this.stackNeedSave = !whenComplete;
        }

        @Override
        public LocationType getLocationType() {
            if (this.whenComplete) {
                return LocationType.SYNC_ENTER_COMPLETED;
            }
            return LocationType.SYNC_ENTER;
        }

        @Override
        public StackSaver getStackSaver() {
            return new StackSaver(){

                @Override
                public void store(InsnList instructions, BindingContext bindingContext) {
                    LocalVariableNode variableNode = bindingContext.getMethodProcessor().initMonitorVariableNode();
                    AsmOpUtils.storeVar(instructions, AsmOpUtils.OBJECT_TYPE, variableNode.index);
                }

                @Override
                public void load(InsnList instructions, BindingContext bindingContext) {
                    LocalVariableNode variableNode = bindingContext.getMethodProcessor().initMonitorVariableNode();
                    AsmOpUtils.loadVar(instructions, AsmOpUtils.OBJECT_TYPE, variableNode.index);
                }

                @Override
                public Type getType(BindingContext bindingContext) {
                    return AsmOpUtils.OBJECT_TYPE;
                }
            };
        }
    }

    public static class InvokeLocation
    extends Location
    implements MethodInsnNodeWare {
        private int count;

        public InvokeLocation(MethodInsnNode insnNode, int count, boolean whenComplete) {
            super((AbstractInsnNode)insnNode, whenComplete);
            this.count = count;
            this.stackNeedSave = false;
        }

        @Override
        public boolean canChangeByReturn() {
            return this.whenComplete;
        }

        public int getCount() {
            return this.count;
        }

        public void setCount(int count) {
            this.count = count;
        }

        @Override
        public LocationType getLocationType() {
            if (this.whenComplete) {
                return LocationType.INVOKE_COMPLETED;
            }
            return LocationType.INVOKE;
        }

        @Override
        public StackSaver getStackSaver() {
            StackSaver stackSaver = null;
            stackSaver = this.whenComplete ? new StackSaver(){

                @Override
                public void store(InsnList instructions, BindingContext bindingContext) {
                    AbstractInsnNode insnNode = bindingContext.getLocation().getInsnNode();
                    MethodProcessor methodProcessor = bindingContext.getMethodProcessor();
                    if (insnNode instanceof MethodInsnNode) {
                        MethodInsnNode methodInsnNode = (MethodInsnNode)insnNode;
                        String uniqueNameForMethod = AsmUtils.uniqueNameForMethod(methodInsnNode.owner, methodInsnNode.name, methodInsnNode.desc);
                        Type invokeReturnType = Type.getMethodType((String)methodInsnNode.desc).getReturnType();
                        if (!invokeReturnType.equals((Object)Type.VOID_TYPE)) {
                            LocalVariableNode invokeReturnVariableNode = methodProcessor.initInvokeReturnVariableNode(uniqueNameForMethod, invokeReturnType);
                            AsmOpUtils.storeVar(instructions, invokeReturnType, invokeReturnVariableNode.index);
                        }
                    } else {
                        throw new IllegalArgumentException("InvokeReturnBinding location is not MethodInsnNode, insnNode: " + insnNode);
                    }
                }

                @Override
                public void load(InsnList instructions, BindingContext bindingContext) {
                    AbstractInsnNode insnNode = bindingContext.getLocation().getInsnNode();
                    MethodProcessor methodProcessor = bindingContext.getMethodProcessor();
                    if (insnNode instanceof MethodInsnNode) {
                        MethodInsnNode methodInsnNode = (MethodInsnNode)insnNode;
                        String uniqueNameForMethod = AsmUtils.uniqueNameForMethod(methodInsnNode.owner, methodInsnNode.name, methodInsnNode.desc);
                        Type invokeReturnType = Type.getMethodType((String)methodInsnNode.desc).getReturnType();
                        if (!invokeReturnType.equals((Object)Type.VOID_TYPE)) {
                            LocalVariableNode invokeReturnVariableNode = methodProcessor.initInvokeReturnVariableNode(uniqueNameForMethod, invokeReturnType);
                            AsmOpUtils.loadVar(instructions, invokeReturnType, invokeReturnVariableNode.index);
                        }
                    } else {
                        throw new IllegalArgumentException("InvokeReturnBinding location is not MethodInsnNode, insnNode: " + insnNode);
                    }
                }

                @Override
                public Type getType(BindingContext bindingContext) {
                    MethodInsnNode methodInsnNode = (MethodInsnNode)InvokeLocation.this.insnNode;
                    return Type.getMethodType((String)methodInsnNode.desc).getReturnType();
                }
            } : new StackSaver(){

                @Override
                public void store(InsnList instructions, BindingContext bindingContext) {
                    Location location = bindingContext.getLocation();
                    MethodProcessor methodProcessor = bindingContext.getMethodProcessor();
                    if (!(location instanceof InvokeLocation)) {
                        throw new IllegalArgumentException("location is not a InvokeLocation, location: " + location);
                    }
                    InvokeLocation invokeLocation = (InvokeLocation)location;
                    MethodInsnNode methodInsnNode = (MethodInsnNode)invokeLocation.getInsnNode();
                    Type methodType = Type.getMethodType((String)methodInsnNode.desc);
                    boolean isStatic = AsmUtils.isStatic(methodInsnNode);
                    Type[] typeArray = methodType.getArgumentTypes();
                }

                @Override
                public void load(InsnList instructions, BindingContext bindingContext) {
                    Location location = bindingContext.getLocation();
                    MethodProcessor methodProcessor = bindingContext.getMethodProcessor();
                    LocalVariableNode invokeArgsVariableNode = methodProcessor.initInvokeArgsVariableNode();
                    if (!(location instanceof InvokeLocation)) {
                        throw new IllegalArgumentException("location is not a InvokeLocation, location: " + location);
                    }
                    InvokeLocation invokeLocation = (InvokeLocation)location;
                    MethodInsnNode methodInsnNode = (MethodInsnNode)invokeLocation.getInsnNode();
                    Type methodType = Type.getMethodType((String)methodInsnNode.desc);
                    boolean isStatic = AsmUtils.isStatic(methodInsnNode);
                    Type[] typeArray = methodType.getArgumentTypes();
                }

                @Override
                public Type getType(BindingContext bindingContext) {
                    throw new UnsupportedOperationException("InvokeLocation saver do not support getType()");
                }
            };
            return stackSaver;
        }

        @Override
        public MethodInsnNode methodInsnNode() {
            return (MethodInsnNode)this.insnNode;
        }
    }

    private static class VariableAccessLocation
    extends AccessLocation {
        private String variableName;
        private boolean isIndex;

        protected VariableAccessLocation(AbstractInsnNode insnNode, String variablename, int count, int flags, boolean whenComplete) {
            super(insnNode, count, flags, whenComplete);
            this.variableName = variablename;
            this.isIndex = variablename.matches("[0-9]+");
        }

        @Override
        public LocationType getLocationType() {
            if ((this.flags & 2) != 0) {
                if (this.whenComplete) {
                    return LocationType.WRITE_COMPLETED;
                }
                return LocationType.WRITE;
            }
            if (this.whenComplete) {
                return LocationType.READ_COMPLETED;
            }
            return LocationType.READ;
        }
    }

    public static class FieldAccessLocation
    extends AccessLocation {
        public FieldAccessLocation(FieldInsnNode fieldInsnNode, int count, int flags, boolean whenComplete) {
            super((AbstractInsnNode)fieldInsnNode, count, flags, whenComplete);
        }
    }

    private static abstract class AccessLocation
    extends Location {
        protected int count;
        protected int flags;

        protected AccessLocation(AbstractInsnNode insnNode, int count, int flags, boolean whenComplete) {
            super(insnNode, whenComplete);
            this.count = count;
            this.flags = flags;
        }

        @Override
        public LocationType getLocationType() {
            if ((this.flags & 2) != 0) {
                if (this.whenComplete) {
                    return LocationType.WRITE_COMPLETED;
                }
                return LocationType.WRITE;
            }
            if (this.whenComplete) {
                return LocationType.READ_COMPLETED;
            }
            return LocationType.READ;
        }
    }

    public static class LineLocation
    extends Location {
        private int targetLine;

        public LineLocation(AbstractInsnNode insnNode, int targetLine) {
            super(insnNode);
            this.targetLine = targetLine;
        }

        @Override
        public LocationType getLocationType() {
            return LocationType.LINE;
        }
    }

    static class EnterLocation
    extends Location {
        public EnterLocation(AbstractInsnNode enterInsnNode) {
            super(enterInsnNode);
            this.insnNode = enterInsnNode;
        }

        @Override
        public LocationType getLocationType() {
            return LocationType.ENTER;
        }
    }
}

