/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.mariadb3.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.TransformAccess;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.plugin.mysql.collector.MysqlCollector;
import com.lubanops.apm.bootstrap.plugin.mysql.collector.MysqlTrace;
import com.lubanops.apm.plugin.mariadb3.interceptor.PreparedStatementInteceptor;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.mariadb.jdbc.Statement;
import org.mariadb.jdbc.client.result.Result;

public class StatementExecuteInterceptor
implements Interceptor {
    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            if (MysqlCollector.INSTANCE.isEnable()) {
                Statement statement = (Statement)object;
                String originsql = (String)args[0];
                Integer id = PreparedStatementInteceptor.getConnectionId((java.sql.Statement)statement);
                PreparedStatementInteceptor.onStart(originsql, id);
                MysqlTrace.onStart((String)className, (String)methodName, (String)originsql, (String)originsql, (Integer)id);
            }
        }
        catch (Exception ex) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)ex);
        }
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        try {
            if (MysqlCollector.INSTANCE.isEnable()) {
                String sql = (String)args[0];
                PreparedStatementInteceptor.onError(e, sql);
                MysqlTrace.onError((Throwable)e);
            }
        }
        catch (Exception ex) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)ex);
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        block7: {
            try {
                if (!MysqlCollector.INSTANCE.isEnable()) break block7;
                Statement statement = (Statement)object;
                String sql = (String)args[0];
                int updateCount = 0;
                int readCount = 0;
                ResultSet resultSet = null;
                try {
                    updateCount = statement.getUpdateCount();
                    resultSet = statement.getResultSet();
                    if (resultSet != null && resultSet instanceof Result) {
                        readCount = PreparedStatementInteceptor.getDataSize((Result)resultSet);
                    }
                }
                catch (SQLException e) {
                    LogFactory.getLogger().log(Level.SEVERE, "sql result error", (Throwable)e);
                }
                MysqlCollector.onFinally((int)updateCount, (int)readCount);
                if (resultSet != null && resultSet instanceof TransformAccess) {
                    MysqlTrace.onFinally((int)updateCount, (int)readCount, (TransformAccess)((TransformAccess)resultSet));
                } else {
                    MysqlTrace.onFinally((int)updateCount, (int)readCount, null);
                }
                MysqlCollector.onConnectionEnd((String)sql, (int)updateCount, (int)readCount);
            }
            catch (Exception ex) {
                LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)ex);
            }
        }
    }
}

