/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.mysql8.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.TransformAccess;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.plugin.mysql.collector.MysqlCollector;
import com.lubanops.apm.bootstrap.plugin.mysql.collector.MysqlTrace;
import com.lubanops.apm.plugin.mysql8.interceptor.PreparedStatementInteceptor;
import com.mysql.cj.PreparedQuery;
import com.mysql.cj.jdbc.ClientPreparedStatement;
import com.mysql.cj.jdbc.StatementImpl;
import com.mysql.cj.jdbc.result.ResultSetImpl;
import java.sql.SQLException;

public class PreparedStatementExecuteInterceptor
implements Interceptor {
    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            if (MysqlCollector.INSTANCE.isEnable()) {
                ClientPreparedStatement mysql8PreparedStatement = (ClientPreparedStatement)object;
                String sql = mysql8PreparedStatement.getPreparedSql();
                Integer id = PreparedStatementInteceptor.getConnectionId((StatementImpl)mysql8PreparedStatement);
                PreparedStatementInteceptor.onStart(sql, id);
                MysqlTrace.onStart((String)className, (String)methodName, (String)sql, (String)this.getOriginSql(mysql8PreparedStatement), (Integer)id);
            }
        }
        catch (Exception ex) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)ex);
        }
        return new Object[0];
    }

    private String getOriginSql(ClientPreparedStatement mysql8PreparedStatement) throws SQLException {
        try {
            return mysql8PreparedStatement.asSql();
        }
        catch (NoSuchMethodError e) {
            return ((PreparedQuery)mysql8PreparedStatement.getQuery()).asSql();
        }
    }

    public void onError(Object object, Object[] args, Throwable throwable, String className, String methodName) {
        try {
            if (MysqlCollector.INSTANCE.isEnable()) {
                ClientPreparedStatement preparedStatement = (ClientPreparedStatement)object;
                String sql = preparedStatement.getPreparedSql();
                PreparedStatementInteceptor.onError(sql, throwable);
                MysqlTrace.onError((Throwable)throwable);
            }
        }
        catch (Exception ex) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)ex);
        }
    }

    public void onFinally(Object mysqlObject, Object[] args, Object result, String className, String methodName) {
        block7: {
            try {
                if (!MysqlCollector.INSTANCE.isEnable()) break block7;
                ClientPreparedStatement preparedStatement = (ClientPreparedStatement)mysqlObject;
                String sql = preparedStatement.getPreparedSql();
                int updatedRowCount = 0;
                ResultSetImpl resultSet = null;
                int readRowCount = 0;
                try {
                    updatedRowCount = preparedStatement.getUpdateCount();
                    resultSet = (ResultSetImpl)preparedStatement.getResultSet();
                    if (resultSet != null && (readRowCount = Integer.valueOf(String.valueOf(resultSet.getUpdateCount())).intValue()) == -1) {
                        readRowCount = 1;
                    }
                }
                catch (SQLException ex) {
                    LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)ex);
                }
                MysqlCollector.onFinally((int)updatedRowCount, (int)readRowCount);
                if (resultSet != null && resultSet instanceof TransformAccess) {
                    MysqlTrace.onFinally((int)updatedRowCount, (int)readRowCount, (TransformAccess)((TransformAccess)resultSet));
                } else {
                    MysqlTrace.onFinally((int)updatedRowCount, (int)readRowCount, null);
                }
                MysqlCollector.onConnectionEnd((String)sql, (int)updatedRowCount, (int)readRowCount);
            }
            catch (Exception ex) {
                LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)ex);
            }
        }
    }
}

