/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.goldenDB.interceptor;

import com.goldendb.jdbc.StatementImpl;
import com.goldendb.jdbc.internal.core.io.ResultSetImpl;
import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.TransformAccess;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.plugin.mysql.collector.MysqlCollector;
import com.lubanops.apm.plugin.goldenDB.interceptor.PreparedStatementInteceptor;
import com.lubanops.apm.plugin.goldenDB.util.GoldenDBTrace;

public class StatementExecuteQueryInterceptor
implements Interceptor {
    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            if (MysqlCollector.INSTANCE.isEnable()) {
                StatementImpl statement = (StatementImpl)object;
                String querySql = (String)args[0];
                Integer id = PreparedStatementInteceptor.getConnectionId(statement);
                PreparedStatementInteceptor.onStart(querySql, id);
                GoldenDBTrace.onStart(className, methodName, querySql, querySql, id);
            }
        }
        catch (Exception ex) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)ex);
        }
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String method) {
        try {
            if (MysqlCollector.INSTANCE.isEnable()) {
                String sql = (String)args[0];
                PreparedStatementInteceptor.onError(sql, e);
                GoldenDBTrace.onError(e);
            }
        }
        catch (Exception ex) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)ex);
        }
    }

    public void onFinally(Object object, Object[] mysql8Args, Object result, String className, String methodName) {
        try {
            if (MysqlCollector.INSTANCE.isEnable()) {
                String sql = (String)mysql8Args[0];
                ResultSetImpl resultSet = (ResultSetImpl)result;
                int readRowCount = 0;
                if (resultSet != null) {
                    readRowCount = ((ResultSetImpl)result).getRow();
                }
                MysqlCollector.onFinally((int)0, (int)readRowCount);
                if (result != null && result instanceof TransformAccess) {
                    TransformAccess transformAccess = (TransformAccess)result;
                    GoldenDBTrace.onFinally(0, readRowCount, transformAccess);
                } else {
                    GoldenDBTrace.onFinally(0, readRowCount, null);
                }
                MysqlCollector.onConnectionEnd((String)sql, (int)0, (int)readRowCount);
            }
        }
        catch (Exception ex) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)ex);
        }
    }
}

