/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.goldenDB.interceptor;

import com.goldendb.jdbc.PreparedStatement;
import com.goldendb.jdbc.StatementImpl;
import com.goldendb.jdbc.internal.core.io.ResultSetImpl;
import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.TransformAccess;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.plugin.mysql.collector.MysqlCollector;
import com.lubanops.apm.plugin.goldenDB.interceptor.PreparedStatementInteceptor;
import com.lubanops.apm.plugin.goldenDB.util.GoldenDBTrace;

public class PreparedStatementExecuteQueryInterceptor
implements Interceptor {
    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            if (MysqlCollector.INSTANCE.isEnable()) {
                PreparedStatement preparedStatement = (PreparedStatement)object;
                String sql = preparedStatement.getPreparedSql();
                Integer id = PreparedStatementInteceptor.getConnectionId((StatementImpl)preparedStatement);
                PreparedStatementInteceptor.onStart(sql, id);
                GoldenDBTrace.onStart(className, methodName, sql, preparedStatement.asSql(), id);
            }
        }
        catch (Exception ex) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)ex);
        }
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable th, String className, String methodName) {
        try {
            PreparedStatement preparedStatement = (PreparedStatement)object;
            String sql = preparedStatement.getPreparedSql();
            PreparedStatementInteceptor.onError(sql, th);
            GoldenDBTrace.onError(th);
        }
        catch (Exception ex) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)ex);
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            if (MysqlCollector.INSTANCE.isEnable()) {
                PreparedStatement preparedStatement = (PreparedStatement)object;
                String sql = preparedStatement.getPreparedSql();
                ResultSetImpl mysql8ResultSet = (ResultSetImpl)result;
                int mysql8ReadRowCount = 0;
                if (mysql8ResultSet != null && (mysql8ReadRowCount = Integer.valueOf(String.valueOf(mysql8ResultSet.getUpdateCount())).intValue()) == -1) {
                    mysql8ReadRowCount = 1;
                }
                MysqlCollector.onFinally((int)0, (int)mysql8ReadRowCount);
                if (result != null && result instanceof TransformAccess) {
                    GoldenDBTrace.onFinally(0, mysql8ReadRowCount, (TransformAccess)result);
                } else {
                    GoldenDBTrace.onFinally(0, mysql8ReadRowCount, null);
                }
                MysqlCollector.onConnectionEnd((String)sql, (int)0, (int)mysql8ReadRowCount);
            }
        }
        catch (Exception ex) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)ex);
        }
    }
}

