/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.jetcd.collector;

import com.lubanops.apm.bootstrap.plugin.common.url.UrlAggregator;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.plugin.jetcd.stats.JetcdStats;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class JetcdWatcherAggregator
extends UrlAggregator<JetcdStats> {
    private final ThreadLocal<Long> startTimeLocal = new ThreadLocal();
    private final ThreadLocal<JetcdStats> statsLocal = new ThreadLocal();

    public void parseParameters(Map<String, String> parameters) {
    }

    public void onStart(String identifier) {
        if (!this.isEnable) {
            return;
        }
        JetcdStats stats = (JetcdStats)this.getValue(new String[]{identifier});
        long startTime = stats.onStart();
        this.statsLocal.set(stats);
        this.startTimeLocal.set(startTime);
    }

    public void onError(String errorTraceId) {
        if (!this.isEnable) {
            return;
        }
        JetcdStats stats = this.statsLocal.get();
        if (stats != null) {
            stats.onError(errorTraceId);
        }
    }

    public void onFinally() {
        long timeUsed;
        if (!this.isEnable) {
            return;
        }
        JetcdStats stats = this.statsLocal.get();
        Long startTime = this.startTimeLocal.get();
        if (stats != null && startTime != null && stats.onFinally(timeUsed = System.nanoTime() - startTime)) {
            stats.setSlowTraceId(TraceCollector.getTraceId());
        }
        this.statsLocal.remove();
        this.startTimeLocal.remove();
    }

    protected Class<JetcdStats> getValueType() {
        return JetcdStats.class;
    }

    protected List<String> primaryKey() {
        return Arrays.asList("listener");
    }

    protected int primaryKeyLength() {
        return 1;
    }

    public String getUrlKey() {
        return "listener";
    }

    public String getName() {
        return "watcher";
    }
}

