/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.rabbitmq.producer.collector;

import com.lubanops.apm.bootstrap.collector.api.MultiPrimaryKeyAggregator;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.plugin.rabbitmq.producer.stats.RabbitMqPublishInvokeStats;
import java.util.Arrays;
import java.util.List;

public class RabbitMqExchangePublishAggregator
extends MultiPrimaryKeyAggregator<RabbitMqPublishInvokeStats> {
    private final ThreadLocal<Long> startTimeLocal = new ThreadLocal();
    private final ThreadLocal<RabbitMqPublishInvokeStats> statsLocal = new ThreadLocal();

    public void setMaxSingleMsgBytes(int bytesCount) {
        if (!this.isEnable) {
            return;
        }
        RabbitMqPublishInvokeStats stats = this.statsLocal.get();
        Long startTime = this.startTimeLocal.get();
        if (stats != null && startTime != null) {
            stats.setMaxSingleMsgBytes(bytesCount);
        }
    }

    public void incrementPublishedMsgCount() {
        RabbitMqPublishInvokeStats stats = this.statsLocal.get();
        Long startTime = this.startTimeLocal.get();
        if (stats != null && startTime != null) {
            stats.incrementPublishedMsgCount();
        }
    }

    public void incrementPublishedBytesCount(int count) {
        if (!this.isEnable) {
            return;
        }
        RabbitMqPublishInvokeStats stats = this.statsLocal.get();
        Long startTime = this.startTimeLocal.get();
        if (stats != null && startTime != null) {
            stats.incrementPublishedBytesCount(count);
        }
    }

    public void onStart(String connection, String exchange) {
        if (!this.isEnable) {
            return;
        }
        RabbitMqPublishInvokeStats stats = (RabbitMqPublishInvokeStats)this.getValue(new String[]{connection, exchange});
        long startTime = stats.onStart();
        this.statsLocal.set(stats);
        this.startTimeLocal.set(startTime);
    }

    public void onError(String errorTraceId) {
        if (!this.isEnable) {
            return;
        }
        RabbitMqPublishInvokeStats stats = this.statsLocal.get();
        if (stats != null) {
            stats.onError(errorTraceId);
        }
    }

    public void onFinally() {
        long timeUsed;
        if (!this.isEnable) {
            return;
        }
        RabbitMqPublishInvokeStats stats = this.statsLocal.get();
        Long startTime = this.startTimeLocal.get();
        if (stats != null && startTime != null && stats.onFinally(timeUsed = System.nanoTime() - startTime)) {
            stats.setSlowTraceId(TraceCollector.getTraceId());
        }
        this.statsLocal.remove();
        this.startTimeLocal.remove();
    }

    protected Class<RabbitMqPublishInvokeStats> getValueType() {
        return RabbitMqPublishInvokeStats.class;
    }

    protected int primaryKeyLength() {
        return 2;
    }

    protected List<String> primaryKey() {
        return Arrays.asList("connection", "exchange");
    }

    public String getName() {
        return "exchangePublish";
    }
}

