/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.rabbitmq.consumer.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.bootstrap.utils.TransformAccessUtils;
import com.lubanops.apm.plugin.rabbitmq.RabbitChannelHolder;
import com.lubanops.apm.plugin.rabbitmq.RabbitMqConfig;
import com.lubanops.apm.plugin.rabbitmq.RabbitMqUtils;
import com.lubanops.apm.plugin.rabbitmq.consumer.collector.RabbitMqConsumerCollector;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.impl.ChannelN;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class BasicConsumeInterceptor
implements Interceptor {
    private final ThreadLocal<Boolean> hasErrorLocal = new ThreadLocal();

    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            RabbitMqConsumerCollector.initTag();
            if (RabbitMqConsumerCollector.INSTANCE.isEnable()) {
                String queue = (String)args[0];
                boolean autoAck = (Boolean)args[1];
                SpanEvent spanEvent = TraceCollector.onStart((String)className, (String)methodName, (String)"RabbitMqConsumer");
                if (spanEvent != null) {
                    spanEvent.addTag("queue", queue);
                    spanEvent.addTag("autoAck", String.valueOf(autoAck));
                }
            }
        }
        catch (Exception rabbitMqConsumeException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)rabbitMqConsumeException);
        }
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        try {
            if (RabbitMqConsumerCollector.INSTANCE.isEnable()) {
                RabbitMqConsumerCollector.onException(e);
                TraceCollector.onError((Throwable)e);
            }
            this.hasErrorLocal.set(Boolean.TRUE);
        }
        catch (Exception rabbitMqConsumeException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)rabbitMqConsumeException);
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            boolean hasError = false;
            if (Boolean.TRUE.equals(this.hasErrorLocal.get())) {
                hasError = true;
            }
            if (!hasError) {
                boolean autoAck = (Boolean)args[1];
                String consumerTag = (String)args[2];
                Consumer consumer = (Consumer)args[6];
                RabbitChannelHolder.registerChannel(RabbitMqUtils.generateConsumerId(consumerTag, consumer), (ChannelN)object);
                Set unackTags = (Set)TransformAccessUtils.getFromLopsAttributeMap((Object)object, (String)"unackedMessageDeliveryTags");
                Set<String> manualAckCustomers = (Set<String>)TransformAccessUtils.getFromLopsAttributeMap((Object)object, (String)"consumersWithManualAck");
                if (unackTags == null) {
                    unackTags = Collections.synchronizedSet(new HashSet());
                    TransformAccessUtils.saveToLopsAttributeMap((Object)object, (String)"unackedMessageDeliveryTags", unackTags);
                }
                if (manualAckCustomers == null) {
                    manualAckCustomers = Collections.synchronizedSet(new HashSet());
                    TransformAccessUtils.saveToLopsAttributeMap((Object)object, (String)"consumersWithManualAck", manualAckCustomers);
                }
                if (!autoAck) {
                    int currentManualAckConsumerCount = RabbitMqConfig.getManualAckConsumerCount();
                    if (currentManualAckConsumerCount < 20) {
                        if (manualAckCustomers.add(consumerTag)) {
                            RabbitMqConfig.incrementManualAckConsumerCount();
                        }
                    } else {
                        LogFactory.getLogger().log(Level.WARNING, "currentManualAckConsumerCount reaches RabbitMqConfig.MAX_CACHED_UNACK_TAGS_PER_CHANNEL.");
                    }
                }
            }
            if (RabbitMqConsumerCollector.INSTANCE.isEnable()) {
                TraceCollector.onFinally();
            }
            this.hasErrorLocal.remove();
        }
        catch (Exception rabbitMqConsumeException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)rabbitMqConsumeException);
        }
    }
}

