/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.plugin.kafka.collector.aggregator;

import com.lubanops.apm.bootstrap.collector.api.AbstractAggregator;
import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.log.Logger;
import com.lubanops.apm.bootstrap.plugin.kafka.collector.KafkaHelper;
import com.lubanops.apm.bootstrap.plugin.kafka.utils.KafkaUtils;
import com.lubanops.apm.bootstrap.plugin.kafka.utils.MbeanUtils;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class KafkaProducerTopicAggregator
extends AbstractAggregator {
    private static final Logger LOGGER = LogFactory.getLogger();
    private MBeanServer server;
    private final Map<String, Map<String, Double>> recordsSentTotalMap = new HashMap<String, Map<String, Double>>();
    private final Map<String, Map<String, Double>> bytesSentTotalMap = new HashMap<String, Map<String, Double>>();

    public String getName() {
        return "topic";
    }

    private MBeanServer getServer() {
        if (this.server == null) {
            this.server = ManagementFactory.getPlatformMBeanServer();
        }
        return this.server;
    }

    public MonitorDataRow getStatus(Map<String, String> primaryKeyMap) {
        return null;
    }

    public List<MonitorDataRow> harvest() {
        ArrayList<MonitorDataRow> result = new ArrayList<MonitorDataRow>();
        HashMap<String, MonitorDataRow> resultMap = new HashMap<String, MonitorDataRow>();
        try {
            ObjectName objName = new ObjectName("kafka.producer:type=producer-topic-metrics,client-id=*,topic=*");
            Set<ObjectName> nn = this.getServer().queryNames(objName, null);
            int count = 0;
            for (ObjectName on : nn) {
                MonitorDataRow map;
                if (++count > 100) break;
                String clientId = on.getKeyProperty("client-id");
                String seqId = KafkaHelper.PRODUCERINFO.getReformatIdSeq(clientId);
                String ips = KafkaHelper.PRODUCERINFO.getIp(clientId);
                if (ips == null) continue;
                String topic = on.getKeyProperty("topic");
                if (seqId != null) {
                    String reformattedId = "producer-{sequenceId}|" + ips;
                    String resultMapKey = reformattedId + "|" + topic;
                    map = (MonitorDataRow)resultMap.get(resultMapKey);
                    if (map == null) {
                        map = new MonitorDataRow();
                        map.put((Object)"id", (Object)reformattedId);
                        map.put((Object)"topic", (Object)topic);
                        resultMap.put(resultMapKey, map);
                    }
                    this.setDataCumulated(map, on, clientId, seqId);
                    continue;
                }
                map = new MonitorDataRow();
                map.put((Object)"id", (Object)(clientId + "|" + ips));
                map.put((Object)"topic", (Object)topic);
                this.setData(map, on);
                result.add(map);
            }
            result.addAll(resultMap.values());
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "collector topic monitor data failed", (Throwable)e);
        }
        return result;
    }

    private void setData(MonitorDataRow row, ObjectName objName) {
        try {
            row.put((Object)"byteRate", (Object)MbeanUtils.getIntValue(this.getServer(), objName, "byte-rate"));
            row.put((Object)"recordErrorRate", (Object)MbeanUtils.getIntValue(this.getServer(), objName, "record-error-rate"));
            row.put((Object)"recordRetryRate", (Object)MbeanUtils.getIntValue(this.getServer(), objName, "record-retry-rate"));
            row.put((Object)"recordSendRate", (Object)MbeanUtils.getIntValue(this.getServer(), objName, "record-send-rate"));
            Double currentRecordSendTotal = MbeanUtils.getIntValue(this.getServer(), objName, "record-send-total");
            Double currentBytesSendTotal = MbeanUtils.getIntValue(this.getServer(), objName, "byte-total");
            Double[] diffs = this.saveDataSentTotal((String)row.get((Object)"id"), (String)row.get((Object)"topic"), currentRecordSendTotal, currentBytesSendTotal);
            row.put((Object)"recordSendTotal", (Object)diffs[0]);
            row.put((Object)"byteTotal", (Object)diffs[1]);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "collector topic monitor data failed", (Throwable)e);
        }
    }

    private void setDataCumulated(MonitorDataRow row, ObjectName objName, String clientId, String seqId) {
        try {
            KafkaUtils.appendSeqId(row, seqId);
            Double cumulatedBytesRate = KafkaUtils.getRowValOrZero(row, "byteRate");
            Double cumulatedRecordErrorRate = KafkaUtils.getRowValOrZero(row, "recordErrorRate");
            Double cumulatedRecordRetryRate = KafkaUtils.getRowValOrZero(row, "recordRetryRate");
            Double cumulatedRecordSendRate = KafkaUtils.getRowValOrZero(row, "recordSendRate");
            row.put((Object)"byteRate", (Object)KafkaUtils.getSum(cumulatedBytesRate, MbeanUtils.getIntValue(this.getServer(), objName, "byte-rate")));
            row.put((Object)"recordErrorRate", (Object)KafkaUtils.getSum(cumulatedRecordErrorRate, MbeanUtils.getIntValue(this.getServer(), objName, "record-error-rate")));
            row.put((Object)"recordRetryRate", (Object)KafkaUtils.getSum(cumulatedRecordRetryRate, MbeanUtils.getIntValue(this.getServer(), objName, "record-retry-rate")));
            row.put((Object)"recordSendRate", (Object)KafkaUtils.getSum(cumulatedRecordSendRate, MbeanUtils.getIntValue(this.getServer(), objName, "record-send-rate")));
            Double currentRecordSendTotal = MbeanUtils.getIntValue(this.getServer(), objName, "record-send-total");
            Double currentBytesSendTotal = MbeanUtils.getIntValue(this.getServer(), objName, "byte-total");
            String topic = (String)row.get((Object)"topic");
            Double[] diffs = this.saveDataSentTotal(clientId, topic, currentRecordSendTotal, currentBytesSendTotal);
            Double recordSentTotal = KafkaUtils.getRowValOrZero(row, "recordSendTotal");
            Double bytesSentTotal = KafkaUtils.getRowValOrZero(row, "byteTotal");
            row.put((Object)"recordSendTotal", (Object)(recordSentTotal + diffs[0]));
            row.put((Object)"byteTotal", (Object)(bytesSentTotal + diffs[1]));
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "collector topic monitor data failed", (Throwable)e);
        }
    }

    private Double[] saveDataSentTotal(String clientId, String topic, Double currentTotalRecordsSent, Double currentTotalBytesSent) {
        if (currentTotalRecordsSent == null) {
            currentTotalRecordsSent = 0.0;
        }
        if (currentTotalBytesSent == null) {
            currentTotalBytesSent = 0.0;
        }
        if (!this.recordsSentTotalMap.containsKey(clientId)) {
            this.recordsSentTotalMap.put(clientId, new HashMap());
        }
        if (!this.bytesSentTotalMap.containsKey(clientId)) {
            this.bytesSentTotalMap.put(clientId, new HashMap());
        }
        Map<String, Double> recordsSentInnerMap = this.recordsSentTotalMap.get(clientId);
        Map<String, Double> bytesSentInnerMap = this.bytesSentTotalMap.get(clientId);
        if (!recordsSentInnerMap.containsKey(topic)) {
            recordsSentInnerMap.put(topic, 0.0);
        }
        if (!bytesSentInnerMap.containsKey(topic)) {
            bytesSentInnerMap.put(topic, 0.0);
        }
        Double preRecordSentTotal = recordsSentInnerMap.get(topic);
        Double preBytesSentTotal = bytesSentInnerMap.get(topic);
        recordsSentInnerMap.put(topic, currentTotalRecordsSent);
        bytesSentInnerMap.put(topic, currentTotalBytesSent);
        return new Double[]{currentTotalRecordsSent - preRecordSentTotal, currentTotalBytesSent - preBytesSentTotal};
    }

    public void removeClientIdFromMaps(String clientId) {
        this.recordsSentTotalMap.remove(clientId);
        this.bytesSentTotalMap.remove(clientId);
    }

    public List<MonitorDataRow> getAllStatus() {
        return null;
    }

    public void clear() {
    }

    public void parseParameters(Map<String, String> parameters) {
    }

    public Map<String, List<MonitorDataRow>> afterHarvest(List<MonitorDataRow> collected) {
        HashMap<String, List<MonitorDataRow>> res = new HashMap<String, List<MonitorDataRow>>();
        ArrayList<MonitorDataRow> totalRowList = new ArrayList<MonitorDataRow>();
        Double totalRecordsSent = 0.0;
        Double totalBytesSent = 0.0;
        for (MonitorDataRow row : collected) {
            totalRecordsSent = totalRecordsSent + (Double)row.get((Object)"recordSendTotal");
            totalBytesSent = totalBytesSent + (Double)row.get((Object)"byteTotal");
        }
        MonitorDataRow totalRow = new MonitorDataRow();
        totalRow.put((Object)"recordSendTotal", (Object)totalRecordsSent);
        totalRow.put((Object)"byteTotal", (Object)totalBytesSent);
        totalRowList.add(totalRow);
        res.put("total", totalRowList);
        return res;
    }
}

