/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.plugin.kafka.collector;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

public class KafkaIdConcurrentHashMap {
    private int maxSize = 100;
    private ConcurrentHashMap<String, String> ipMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, String> reformatIdMap = new ConcurrentHashMap();
    private ConcurrentLinkedQueue<String> clientIdQueue = new ConcurrentLinkedQueue();

    public void addIp(String key, String value) {
        if (this.ipMap.size() > this.maxSize) {
            this.clearWhenExceedLimit();
        }
        this.ipMap.put(key, value);
        this.clientIdQueue.add(key);
    }

    public String getIp(String key) {
        return this.ipMap.get(key);
    }

    public void addReformatIdSeq(String key, String value) {
        this.reformatIdMap.put(key, value);
    }

    public String getReformatIdSeq(String key) {
        return this.reformatIdMap.get(key);
    }

    public String clearWhenExceedLimit() {
        String clientIdToRemove = this.clientIdQueue.poll();
        this.ipMap.remove(clientIdToRemove);
        if (this.reformatIdMap.containsKey(clientIdToRemove)) {
            this.reformatIdMap.remove(clientIdToRemove);
        }
        return clientIdToRemove;
    }
}

