/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.utils;

import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import java.util.concurrent.ConcurrentHashMap;

public class IntegerMap {
    private String[] resources;
    private ConcurrentHashMap<String, Integer> concurrentHashMap = new ConcurrentHashMap();
    private volatile boolean isfull = false;
    private volatile int size = 0;
    private volatile int max;

    public IntegerMap(int max) {
        if (max > 1000) {
            throw new RuntimeException("exeed the max value:1000");
        }
        this.resources = new String[max];
        this.max = max;
    }

    public int registerResource(String r) {
        Integer b = this.concurrentHashMap.get(r);
        if (b != null) {
            return b;
        }
        if (this.isfull) {
            return -1;
        }
        return this.syncRegister(r);
    }

    private synchronized int syncRegister(String r) {
        Integer b = this.concurrentHashMap.get(r);
        if (b != null) {
            return b;
        }
        this.resources[this.size] = r;
        this.concurrentHashMap.put(r, this.size);
        int c = this.size++;
        if (this.size >= this.max) {
            this.isfull = true;
            LogFactory.getLogger().log(Level.SEVERE, String.format("map is full content:[%s]", this.concurrentHashMap));
        }
        return c;
    }

    public int size() {
        return this.size;
    }

    public final String getResource(int b) {
        return this.resources[b];
    }
}

