/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.utils;

import com.lubanops.apm.bootstrap.utils.DefaultNormalizedSql;
import com.lubanops.apm.bootstrap.utils.NormalizedSql;
import com.lubanops.apm.bootstrap.utils.SqlParser;
import com.lubanops.apm.bootstrap.utils.StringUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;

public class DefaultSqlParser
implements SqlParser {
    public static final char SEPARATOR = ',';
    public static final char SYMBOL_REPLACE = '$';
    public static final char NUMBER_REPLACE = '#';
    private static final int NEXT_TOKEN_NOT_EXIST = -1;
    private static final int NORMALIZED_SQL_BUFFER = 32;
    private static final NormalizedSql NULL_OBJECT = new DefaultNormalizedSql("", "");
    private static final Set NORMAL_CHAR = new HashSet<Character>(Arrays.asList(Character.valueOf(' '), Character.valueOf('\t'), Character.valueOf('\n'), Character.valueOf('\r'), Character.valueOf('*'), Character.valueOf('+'), Character.valueOf('%'), Character.valueOf('='), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf('&'), Character.valueOf('|'), Character.valueOf('^'), Character.valueOf('~'), Character.valueOf('!'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf(','), Character.valueOf(';')));
    private static final Set SEC_CHAR = new HashSet<Character>(Arrays.asList(Character.valueOf('.'), Character.valueOf('_'), Character.valueOf('@'), Character.valueOf(':')));

    @Override
    public NormalizedSql normalizedSql(String sql) {
        if ((sql = sql.toLowerCase().trim()).isEmpty()) {
            return NULL_OBJECT;
        }
        int length = sql.length();
        StringBuilder normalized = new StringBuilder(length + 32);
        StringBuilder parsedParameter = new StringBuilder(32);
        boolean change = false;
        boolean replaceIndex = false;
        boolean numberTokenStartEnable = true;
        for (int i = 0; i < length; ++i) {
            char ch = sql.charAt(i);
            if (ch == '/') {
                i = this.processVirgule(sql, length, normalized, i, ch);
                continue;
            }
            if (ch == '-') {
                if (this.lookAhead1(sql, i) == 45) {
                    normalized.append("--");
                    i += 2;
                    i = this.readLine(sql, normalized, i);
                    continue;
                }
                numberTokenStartEnable = true;
                normalized.append(ch);
                continue;
            }
            if (ch == '\'') {
                i = this.processBlackSlash(sql, length, normalized, parsedParameter, i);
                continue;
            }
            if (ch >= '0' && ch <= '9') {
                i = this.process9(sql, length, normalized, parsedParameter, numberTokenStartEnable, i, ch);
                continue;
            }
            if (NORMAL_CHAR.contains(Character.valueOf(ch))) {
                numberTokenStartEnable = true;
                normalized.append(ch);
                continue;
            }
            if (SEC_CHAR.contains(Character.valueOf(ch))) {
                numberTokenStartEnable = false;
                normalized.append(ch);
                continue;
            }
            numberTokenStartEnable = !(ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z');
            normalized.append(ch);
        }
        return this.getDefaultNormalizedSql(normalized, parsedParameter);
    }

    private DefaultNormalizedSql getDefaultNormalizedSql(StringBuilder normalized, StringBuilder parsedParameter) {
        String parsedParameterString = parsedParameter.length() > 0 ? parsedParameter.toString() : "";
        String[] resArray = normalized.toString().split(",");
        StringBuilder res = new StringBuilder();
        for (String ele : resArray) {
            String eleTrim = ele.trim();
            if ("".equals(eleTrim)) continue;
            if (eleTrim.length() == 1) {
                if (eleTrim.equals("?")) continue;
                res.append(eleTrim);
                continue;
            }
            if (eleTrim.charAt(0) == '?') {
                res.append(eleTrim.substring(1));
                continue;
            }
            res.append(",");
            res.append(eleTrim);
        }
        return new DefaultNormalizedSql(res.toString().substring(1, res.length()), parsedParameterString);
    }

    private int process9(String sql, int length, StringBuilder normalized, StringBuilder parsedParameter, boolean numberTokenStartEnable, int i, char ch) {
        if (numberTokenStartEnable) {
            boolean change = true;
            normalized.append('?');
            this.appendOutputSeparator(parsedParameter);
            this.appendOutputParam(parsedParameter, ch);
            ++i;
            while (i < length) {
                char stateCh = sql.charAt(i);
                if (stateCh != '0' && stateCh != '1' && stateCh != '2' && stateCh != '3' && stateCh != '4' && stateCh != '5' && stateCh != '6' && stateCh != '7' && stateCh != '8' && stateCh != '9' && stateCh != '.' && stateCh != 'E' && stateCh != 'e') {
                    --i;
                    break;
                }
                this.appendOutputParam(parsedParameter, stateCh);
                ++i;
            }
            return i;
        }
        normalized.append(ch);
        return i;
    }

    private int processBlackSlash(String sql, int length, StringBuilder normalized, StringBuilder parsedParameter, int i) {
        if (this.lookAhead1(sql, i) == 39) {
            normalized.append("''");
            return i += 2;
        }
        normalized.append('?');
        ++i;
        this.appendOutputSeparator(parsedParameter);
        while (i < length) {
            char stateCh = sql.charAt(i);
            if (stateCh == '\'') {
                if (this.lookAhead1(sql, i) != 39) break;
                ++i;
                this.appendOutputParam(parsedParameter, "''");
            } else {
                this.appendSeparatorCheckOutputParam(parsedParameter, stateCh);
            }
            ++i;
        }
        return i;
    }

    private int processVirgule(String sql, int length, StringBuilder normalized, int i, char ch) {
        int lookAhead1Char = this.lookAhead1(sql, i);
        if (lookAhead1Char == 42) {
            normalized.append("/*");
            i += 2;
            while (i < length) {
                char stateCh = sql.charAt(i);
                if (stateCh == '*' && this.lookAhead1(sql, i) == 47) {
                    normalized.append("*/");
                    ++i;
                    break;
                }
                normalized.append(stateCh);
                ++i;
            }
            return i;
        }
        if (lookAhead1Char == 47) {
            normalized.append("//");
            i += 2;
            i = this.readLine(sql, normalized, i);
            return i;
        }
        normalized.append(ch);
        return i;
    }

    private int readLine(String sql, StringBuilder normalized, int index) {
        int length = sql.length();
        while (index < length) {
            char ch = sql.charAt(index);
            normalized.append(ch);
            if (ch == '\n') break;
            ++index;
        }
        return index;
    }

    private void appendOutputSeparator(StringBuilder output) {
        if (output.length() == 0) {
            return;
        }
        output.append(',');
    }

    private void appendOutputParam(StringBuilder output, String str) {
        output.append(str);
    }

    private void appendSeparatorCheckOutputParam(StringBuilder output, char ch) {
        if (ch == ',') {
            output.append(",,");
        } else {
            output.append(ch);
        }
    }

    private void appendOutputParam(StringBuilder output, char ch) {
        output.append(ch);
    }

    private int lookAhead1(String sql, int index) {
        if (++index < sql.length()) {
            return sql.charAt(index);
        }
        return -1;
    }

    @Override
    public String combineOutputParams(String sql, List<String> outputParams) {
        int length = sql.length();
        StringBuilder normalized = new StringBuilder(length + 16);
        for (int i = 0; i < length; ++i) {
            char ch = sql.charAt(i);
            if (ch == '/') {
                i = this.processVirgule(sql, length, normalized, i, ch);
                continue;
            }
            if (ch == '-') {
                if (this.lookAhead1(sql, i) == 45) {
                    normalized.append("--");
                    i += 2;
                    i = this.readLine(sql, normalized, i);
                    break;
                }
                normalized.append(ch);
                break;
            }
            if (ch >= '0' && ch <= '9') {
                i = this.processCombine9(sql, outputParams, length, normalized, i, ch);
                continue;
            }
            normalized.append(ch);
        }
        return normalized.toString();
    }

    private int processCombine9(String sql, List<String> outputParams, int length, StringBuilder normalized, int i, char ch) {
        if (this.lookAhead1(sql, i) == -1) {
            normalized.append(ch);
            return i;
        }
        StringBuilder outputIndex = new StringBuilder();
        outputIndex.append(ch);
        ++i;
        block5: while (i < length) {
            char stateCh = sql.charAt(i);
            switch (stateCh) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    if (this.lookAhead1(sql, i) == -1) {
                        outputIndex.append(stateCh);
                        normalized.append(outputIndex.toString());
                        break block5;
                    }
                    outputIndex.append(stateCh);
                    break;
                }
                case '#': {
                    this.numberReplace(outputIndex, normalized, outputParams);
                    break block5;
                }
                case '$': {
                    this.symbolReplace(outputIndex, normalized, outputParams);
                    break block5;
                }
                default: {
                    normalized.append(outputIndex.toString());
                    --i;
                    break block5;
                }
            }
            ++i;
        }
        return i;
    }

    private void numberReplace(StringBuilder outputIndex, StringBuilder normalized, List<String> outputParams) {
        int numberIndex = 0;
        try {
            numberIndex = Integer.parseInt(outputIndex.toString());
        }
        catch (NumberFormatException e) {
            normalized.append(outputIndex.toString());
            normalized.append('#');
            return;
        }
        try {
            String replaceNumber = outputParams.get(numberIndex);
            normalized.append(replaceNumber);
        }
        catch (IndexOutOfBoundsException e) {
            normalized.append(outputIndex.toString());
            normalized.append('#');
            return;
        }
    }

    private void symbolReplace(StringBuilder outputIndex, StringBuilder normalized, List<String> outputParams) {
        int symbolIndex = 0;
        try {
            symbolIndex = Integer.parseInt(outputIndex.toString());
        }
        catch (NumberFormatException e) {
            normalized.append(outputIndex.toString());
            normalized.append('$');
        }
        try {
            String replaceSymbol = outputParams.get(symbolIndex);
            normalized.append(replaceSymbol);
        }
        catch (IndexOutOfBoundsException e) {
            normalized.append(outputIndex.toString());
            normalized.append('$');
        }
    }

    private Queue<String> getBindValueQueue(List<String> bindValues) {
        LinkedList<String> bindValueQueue = new LinkedList<String>();
        for (String value : bindValues) {
            bindValueQueue.add(value.trim());
        }
        return bindValueQueue;
    }

    @Override
    public String combineBindValues(String sql, List<String> bindValues) {
        if (StringUtils.isBlank(sql) || bindValues.isEmpty()) {
            return sql;
        }
        Queue<String> bindValueQueue = this.getBindValueQueue(bindValues);
        int length = sql.length();
        StringBuilder result = new StringBuilder(length + 16);
        boolean inQuotes = false;
        char quoteChar = '\u0000';
        for (int i = 0; i < length; ++i) {
            char ch = sql.charAt(i);
            if (inQuotes) {
                if ((ch == '\'' || ch == '\"') && ch == quoteChar) {
                    if (this.lookAhead1(sql, i) == quoteChar) {
                        result.append(ch);
                        ++i;
                        continue;
                    }
                    inQuotes = !inQuotes;
                    quoteChar = '\u0000';
                }
                result.append(ch);
                continue;
            }
            if (ch == '/') {
                i = this.processVirgule(sql, length, result, i, ch);
                continue;
            }
            if (ch == '-') {
                if (this.lookAhead1(sql, i) == 45) {
                    result.append("--");
                    i += 2;
                    i = this.readLine(sql, result, i);
                    continue;
                }
                result.append(ch);
                continue;
            }
            if (ch == '\'' || ch == '\"') {
                inQuotes = true;
                quoteChar = ch;
                result.append(ch);
                continue;
            }
            if (ch == '?') {
                if (bindValueQueue.isEmpty()) continue;
                result.append('\'').append(bindValueQueue.poll()).append('\'');
                continue;
            }
            result.append(ch);
        }
        return result.toString();
    }
}

