/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.transaction;

import com.lubanops.apm.bootstrap.collector.api.PrimaryKey;
import com.lubanops.apm.bootstrap.config.AgentConfigManager;
import com.lubanops.apm.bootstrap.config.IdentityConfigManager;
import com.lubanops.apm.bootstrap.transaction.Transaction;
import com.lubanops.apm.bootstrap.transaction.TransactionStats;
import com.lubanops.apm.bootstrap.transaction.TxConfigItem;
import com.lubanops.apm.bootstrap.utils.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class TransactionCollector {
    private static ConcurrentMap<PrimaryKey, TransactionStats> valueStats = new ConcurrentHashMap<PrimaryKey, TransactionStats>(2048);
    private static boolean isFull = false;
    private static ThreadLocal<List<String>> txNameLocal = new ThreadLocal();
    private static HashMap<TxConfigItem, String> txConfigItemSet = new HashMap();
    private static int maxRowCount = 2000;

    public static void collect(long timeUsed, boolean isError, String sourveEnvId, String targetEnvId, List<String> transactionNames, String txType) {
        if (AgentConfigManager.isTxEnable() && transactionNames != null) {
            for (String transactionName : transactionNames) {
                String isDirection;
                PrimaryKey pk;
                TransactionStats stats;
                if (StringUtils.isBlank(transactionName)) continue;
                boolean isRoot = transactionName.endsWith("-r");
                if (isRoot) {
                    transactionName = transactionName.substring(0, transactionName.length() - 2);
                }
                if ((stats = TransactionCollector.getValue(pk = new PrimaryKey(transactionName, sourveEnvId, targetEnvId, txType), isDirection = TransactionCollector.isDirection(txType))) == null) continue;
                if ("in".equals(isDirection) && isRoot) {
                    stats.setIsRoot(1);
                }
                stats.getInvokeCount().incrementAndGet();
                stats.getTotalTime().addAndGet(timeUsed);
                if (!isError) continue;
                stats.getErrorCount().incrementAndGet();
            }
        }
    }

    public static void setTxName(List<String> txName) {
        txNameLocal.set(txName);
    }

    public static List<String> getTxName() {
        return txNameLocal.get();
    }

    public static void clear() {
        txNameLocal.set(null);
    }

    public static String generateTxName(String url) {
        StringBuilder sb = new StringBuilder();
        sb.append(IdentityConfigManager.getBizId()).append("-").append(IdentityConfigManager.getAppId()).append("-").append(IdentityConfigManager.getEnvId()).append("|").append(url);
        return sb.toString();
    }

    public static void generateTxList(String txNameValue, String url, String method) {
        String txId;
        ArrayList<Object> oldTxNameList = new ArrayList();
        if (!StringUtils.isBlank(txNameValue)) {
            String[] txNames = txNameValue.split(",");
            oldTxNameList = new ArrayList<String>(Arrays.asList(txNames));
        }
        TxConfigItem key = new TxConfigItem(url, method);
        if (!StringUtils.isBlank(url) && txConfigItemSet.containsKey(key) && !oldTxNameList.contains(txId = txConfigItemSet.get(key))) {
            oldTxNameList.add(txId + "-r");
        }
        txNameLocal.set(oldTxNameList);
    }

    public static void setMaxRowCount(int newMaxRowCount) {
        if (newMaxRowCount != maxRowCount) {
            maxRowCount = newMaxRowCount;
            valueStats.clear();
            isFull = false;
        }
    }

    private static String isDirection(String txType) {
        if ("Url".equals(txType)) {
            return "in";
        }
        return "out";
    }

    private static TransactionStats getValue(PrimaryKey pk, String direction) {
        TransactionStats v = (TransactionStats)valueStats.get(pk);
        if (v != null) {
            return v;
        }
        if (isFull) {
            return null;
        }
        v = new TransactionStats(direction);
        TransactionStats oldvalue = valueStats.putIfAbsent(pk, v);
        if (valueStats.size() >= maxRowCount) {
            isFull = true;
        }
        if (oldvalue != null) {
            v = oldvalue;
        }
        return v;
    }

    public static List<Transaction> harvest() {
        if (valueStats.isEmpty()) {
            return null;
        }
        ArrayList<Transaction> rowList = new ArrayList<Transaction>();
        for (Map.Entry entry : valueStats.entrySet()) {
            PrimaryKey pk = (PrimaryKey)entry.getKey();
            TransactionStats stats = (TransactionStats)entry.getValue();
            long invokeCount = stats.getInvokeCount().getAndSet(0L);
            if (invokeCount <= 0L) continue;
            Transaction transaction = new Transaction();
            transaction.setTransactionName(pk.get(0));
            transaction.setSourceEnvId(pk.get(1));
            transaction.setTargetEnvId(pk.get(2));
            transaction.setType(pk.get(3));
            transaction.setErrorCount(stats.getErrorCount().getAndSet(0L));
            transaction.setTotalTime(stats.getTotalTime().getAndSet(0L) / 1000000L);
            transaction.setInvokeCount(invokeCount);
            transaction.setDirection(stats.isDirection());
            transaction.setIsRoot(stats.getIsRoot());
            rowList.add(transaction);
        }
        return rowList;
    }

    public static void setTxConfigItemList(List<TxConfigItem> txConfigItemList) {
        if (txConfigItemList == null) {
            return;
        }
        HashMap<TxConfigItem, String> txConfigItems = new HashMap<TxConfigItem, String>();
        for (TxConfigItem txConfigItem : txConfigItemList) {
            txConfigItems.put(txConfigItem, String.valueOf(txConfigItem.getTxId()));
        }
        txConfigItemSet = txConfigItems;
    }
}

