/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.commons;

import com.lubanops.apm.bootstrap.utils.StringUtils;
import java.util.regex.Pattern;

public class ValidatorUtil {
    public static void validate(String key, String value, boolean notNull, int length, String regex) {
        if (StringUtils.isBlank(key)) {
            throw new IllegalArgumentException(String.format("[PARAMETER CHECK] input key[{%s}] is blank.", key));
        }
        if (StringUtils.isBlank(value)) {
            if (notNull) {
                throw new IllegalArgumentException(String.format("[PARAMETER CHECK]value of key[{%s}] can't be empty.", key));
            }
            return;
        }
        if (value.length() > length) {
            throw new IllegalArgumentException(String.format("[PARAMETER CHECK] key[{%s}]value of key[{%s}] must contain less than 64 characters.", key, key));
        }
        if (!StringUtils.isBlank(regex) && !Pattern.matches(regex, value)) {
            throw new IllegalArgumentException(String.format("[PARAMETER CHECK] key[{%s}] value[%s] contain illegal characters.", key, value));
        }
    }
}

