/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.jedis.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.TransformAccess;
import com.lubanops.apm.bootstrap.otel.ConstantsTrace;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.plugin.redis.collector.RedisCollector;
import com.lubanops.apm.plugin.redis.collector.commons.RedisTags;
import com.lubanops.apm.plugin.redis.collector.commons.RedisTransformHelper;
import java.nio.charset.Charset;
import java.util.Arrays;

public class JedisSingleCallInterceptor
implements Interceptor {
    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        if (RedisCollector.getInstance().isEnable()) {
            TraceCollector.onStart((String)className, (String)methodName, (String)RedisCollector.getInstance().getCollectorName(), (String)methodName, (String)"CLIENT");
            RedisCollector.onStart(methodName, this.getConnectionId(object));
        }
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        if (RedisCollector.getInstance().isEnable()) {
            SpanEvent spanEvent = TraceCollector.onError((Throwable)e);
            String traceId = null;
            if (spanEvent != null) {
                traceId = spanEvent.getTraceId();
            }
            RedisCollector.onThrowable(e, traceId);
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        if (RedisCollector.getInstance().isEnable()) {
            SpanEvent spanEvent = TraceCollector.getSpanEvent();
            this.renderRedisBody(object, args, result, methodName, spanEvent);
            String traceId = null;
            if (spanEvent != null) {
                traceId = spanEvent.getTraceId();
            }
            if (RedisTransformHelper.isHitMethod(methodName)) {
                boolean hit = result != null;
                RedisCollector.onFinally(false, hit, 0L, traceId, true);
                if (spanEvent != null && hit) {
                    spanEvent.addTag(RedisTags.hit.name(), "true");
                }
            } else {
                RedisCollector.onFinally(false, 0L, traceId);
            }
            TraceCollector.onFinally();
        }
    }

    private void renderRedisBody(Object object, Object[] args, Object result, String methodName, SpanEvent spanEvent) {
        if (spanEvent != null && object instanceof TransformAccess) {
            TransformAccess transformAccess;
            Object connectionIdObject;
            if (RedisCollector.getInstance().isRedisParseBody()) {
                String reply = String.valueOf(result);
                if (result instanceof byte[]) {
                    byte[] resultBytes = (byte[])result;
                    if (resultBytes.length > RedisCollector.getInstance().getParseRedisLength()) {
                        resultBytes = Arrays.copyOfRange(resultBytes, 0, RedisCollector.getInstance().getParseRedisLength());
                    }
                    reply = new String(resultBytes, Charset.forName("UTF-8"));
                }
                spanEvent.addTag("result", reply);
                StringBuilder argsSb = new StringBuilder();
                boolean hasArgs = false;
                for (Object arg : args) {
                    String argStr = String.valueOf(arg);
                    if (arg instanceof byte[]) {
                        byte[] argBytes = (byte[])arg;
                        if (argBytes.length > RedisCollector.getInstance().getParseRedisLength()) {
                            argBytes = Arrays.copyOfRange(argBytes, 0, RedisCollector.getInstance().getParseRedisLength());
                        }
                        argStr = new String(argBytes, Charset.forName("UTF-8"));
                    }
                    if (hasArgs) {
                        argsSb.append(",").append(argStr);
                        continue;
                    }
                    argsSb.append(argStr);
                    hasArgs = true;
                }
                if (hasArgs) {
                    spanEvent.addTag("args", argsSb.toString());
                }
            }
            if (null != (connectionIdObject = (transformAccess = (TransformAccess)object).getLopsAttribute()) && connectionIdObject.toString().length() > 0) {
                spanEvent.addTag(RedisTags.host.name(), connectionIdObject.toString(), RedisCollector.getInstance().getParseRedisLength());
                TraceCollector.addOtelAttribute((String)ConstantsTrace.AttributeDBConnectionString.toString(), (Object)connectionIdObject.toString());
            }
            TraceCollector.addOtelAttribute((String)ConstantsTrace.AttributeDBSystem.toString(), (Object)ConstantsTrace.AttributeDBSystemRedis.toString());
            TraceCollector.addOtelAttribute((String)ConstantsTrace.AttributeDBStatement.toString(), (Object)methodName);
        }
    }

    private String getConnectionId(Object object) {
        TransformAccess transformAccess;
        Object connectionIdObject;
        String connection = "";
        if (object instanceof TransformAccess && null != (connectionIdObject = (transformAccess = (TransformAccess)object).getLopsAttribute()) && connectionIdObject.toString().length() > 0) {
            connection = connectionIdObject.toString();
        }
        return connection;
    }
}

