/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gaussdb.jdbc.util;

import com.huawei.gaussdb.jdbc.util.GT;
import com.huawei.gaussdb.jdbc.util.StreamWrapper;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.logging.Level;
import java.util.logging.Logger;

class StreamWrapperFinalizeAction
implements Closeable {
    private static final Logger LOGGER = Logger.getLogger(StreamWrapper.class.getName());
    private InputStream stream;
    private Path tempFile;

    StreamWrapperFinalizeAction(Path tempFile) {
        this.tempFile = tempFile;
    }

    public InputStream getStream() throws IOException {
        InputStream inputStream = this.stream;
        if (inputStream == null) {
            this.stream = inputStream = Files.newInputStream(this.tempFile, new OpenOption[0]);
        }
        return inputStream;
    }

    @Override
    public void close() throws IOException {
        InputStream inputStream;
        Path file = this.tempFile;
        if (file != null) {
            boolean isDeleted = file.toFile().delete();
            if (!isDeleted) {
                LOGGER.log(Level.FINER, GT.tr("tempFile delete failed!", new Object[0]).replaceAll("[\r\n]", ""));
            }
            this.tempFile = null;
        }
        if ((inputStream = this.stream) != null) {
            inputStream.close();
            this.stream = null;
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public String toString() {
        return "StreamWrapperFinalizeAction{stream=" + this.stream + ", tempFile=" + this.tempFile + '}';
    }
}

