/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gaussdb.jdbc.jdbc.alt.tac;

import com.huawei.gaussdb.jdbc.PGConnection;
import com.huawei.gaussdb.jdbc.core.QueryExecutor;
import com.huawei.gaussdb.jdbc.jdbc.alt.batch.TacBatchExecution;
import com.huawei.gaussdb.jdbc.jdbc.alt.cluster.ALTContext;
import com.huawei.gaussdb.jdbc.jdbc.alt.enums.FanDBNodeStatus;
import com.huawei.gaussdb.jdbc.jdbc.alt.enums.TaskCnType;
import com.huawei.gaussdb.jdbc.jdbc.alt.enums.TaskMasterDnType;
import com.huawei.gaussdb.jdbc.jdbc.alt.exception.ALTException;
import com.huawei.gaussdb.jdbc.jdbc.alt.fan.FanDBNodeInfo;
import com.huawei.gaussdb.jdbc.jdbc.alt.fan.FanTask;
import com.huawei.gaussdb.jdbc.jdbc.alt.tac.ConnTracStateObserver;
import com.huawei.gaussdb.jdbc.jdbc.alt.tac.TacClusterInfo;
import com.huawei.gaussdb.jdbc.jdbc.alt.tac.TacReConnectActuator;
import com.huawei.gaussdb.jdbc.jdbc.alt.tac.TacReConnectInfo;
import com.huawei.gaussdb.jdbc.jdbc.alt.util.LoggerUtil;
import com.huawei.gaussdb.jdbc.jdbc.alt.util.TacReConnectUtil;
import com.huawei.gaussdb.jdbc.log.Log;
import com.huawei.gaussdb.jdbc.log.Logger;
import com.huawei.gaussdb.jdbc.util.HostSpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class TacTracker {
    private static final Log LOGGER = Logger.getLogger(TacTracker.class.getName());
    private static final long QUERY_INFO_TIMEOUT = TimeUnit.SECONDS.toMillis(6L);
    private final Map<String, TacClusterInfo> tacClusterInfoMap = new ConcurrentHashMap<String, TacClusterInfo>();

    private TacTracker() {
    }

    public static TacTracker getInstance() {
        return InstanceHolder.INSTANCE;
    }

    public void tacShutDownAll(FanTask task, Map<HostSpec, FanDBNodeInfo> cluster) {
        TacClusterInfo tacClusterInfo = new TacClusterInfo();
        List<FanDBNodeInfo> clusterAllNodes = this.getAllNodeInCluster(cluster);
        tacClusterInfo.setMaintenanceNodes(clusterAllNodes);
        this.tacClusterInfoMap.put(task.getAltClusterId(), tacClusterInfo);
        this.setMaintenanceStatus(tacClusterInfo.getMaintenanceNodes(), task);
    }

    public void tacShutDownDn(FanTask task, Map<HostSpec, FanDBNodeInfo> cluster, FanDBNodeInfo currentNode) {
        TacClusterInfo tacClusterInfo = new TacClusterInfo();
        if (currentNode.getDBNodeStatus() == FanDBNodeStatus.ACTIVE_SECONDARY) {
            tacClusterInfo.setMaintenanceNodes(currentNode);
        } else {
            tacClusterInfo.setMaintenanceNodes(this.getAllNodeInCluster(cluster));
        }
        this.tacClusterInfoMap.put(task.getAltClusterId(), tacClusterInfo);
        this.setMaintenanceStatus(tacClusterInfo.getMaintenanceNodes(), task);
    }

    public void tacShutDownNode(FanTask task, Map<HostSpec, FanDBNodeInfo> cluster, FanDBNodeInfo currentNode) {
        this.tacShutDownDn(task, cluster, currentNode);
    }

    public void tacDistShutDownNode(FanTask task, Map<HostSpec, FanDBNodeInfo> cluster, FanDBNodeInfo currentNode) {
        if (task.getCnType() == TaskCnType.CN_NOT_CLOSED && task.getTaskMasterDnType() == TaskMasterDnType.DN_MASTER_NOT_CLOSED) {
            return;
        }
        if (task.getCnType() == TaskCnType.CN_NOT_CLOSED && task.getTaskMasterDnType() == TaskMasterDnType.DN_MASTER_CLOSED) {
            this.tacDistShutDownDnMaster(task, cluster);
            return;
        }
        if (task.getCnType() == TaskCnType.CN_CLOSED && task.getTaskMasterDnType() == TaskMasterDnType.DN_MASTER_CLOSED) {
            LoggerUtil.debug(LOGGER, "The distributed node is down, the CN is down, and the primary DN is down.");
            TacClusterInfo tacClusterInfo = new TacClusterInfo();
            List<FanDBNodeInfo> clusterAllNodes = this.getAllNodeInCluster(cluster);
            tacClusterInfo.setMaintenanceNodes(clusterAllNodes);
            this.tacClusterInfoMap.put(task.getAltClusterId(), tacClusterInfo);
            this.setMaintenanceStatus(clusterAllNodes, task);
            return;
        }
        if (task.getCnType() == TaskCnType.CN_CLOSED && task.getTaskMasterDnType() == TaskMasterDnType.DN_MASTER_NOT_CLOSED) {
            LoggerUtil.debug(LOGGER, "The distributed node is down, the CN is down, and the primary DN is not down.");
            TacClusterInfo tacClusterInfo = new TacClusterInfo();
            tacClusterInfo.setMaintenanceNodes(currentNode);
            this.tacClusterInfoMap.put(task.getAltClusterId(), tacClusterInfo);
            this.setMaintenanceStatus(tacClusterInfo.getMaintenanceNodes(), task);
        }
    }

    public void tacDistShutDownDnMaster(FanTask task, Map<HostSpec, FanDBNodeInfo> cluster) {
        TacClusterInfo tacClusterInfo = new TacClusterInfo();
        List<FanDBNodeInfo> clusterAllNodes = this.getAllNodeInCluster(cluster);
        tacClusterInfo.setMaintenanceNodes(clusterAllNodes);
        this.tacClusterInfoMap.put(task.getAltClusterId(), tacClusterInfo);
        this.setMaintenanceStatus(clusterAllNodes, task);
    }

    public void tacSwitchoverNode(FanTask task, Map<HostSpec, FanDBNodeInfo> cluster) {
        TacClusterInfo tacClusterInfo = new TacClusterInfo();
        List<FanDBNodeInfo> clusterAllNodes = this.getAllNodeInCluster(cluster);
        tacClusterInfo.setMaintenanceNodes(clusterAllNodes);
        this.tacClusterInfoMap.put(task.getAltClusterId(), tacClusterInfo);
        this.setMaintenanceStatus(clusterAllNodes, task);
    }

    private List<FanDBNodeInfo> getAllNodeInCluster(Map<HostSpec, FanDBNodeInfo> cluster) {
        return new ArrayList<FanDBNodeInfo>(cluster.values());
    }

    private void setMaintenanceStatus(List<FanDBNodeInfo> targetDBNodes, FanTask task) {
        LoggerUtil.debug(LOGGER, "Begin setMaintenanceStatus");
        TacTracker.registerTransactionStateObserver(targetDBNodes);
        for (FanDBNodeInfo fanDBNodeInfo : targetDBNodes) {
            fanDBNodeInfo.setIsInTacStatus(true);
        }
        while (!this.tacIsTimeOut(task.getAltClusterId()) && !TacTracker.isAllConnectionHasLock(targetDBNodes)) {
            try {
                TimeUnit.SECONDS.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
                break;
            }
        }
        TacTracker.unRegisterTransactionStateObserver(targetDBNodes);
        LoggerUtil.debug(LOGGER, "End setMaintenanceStatus");
    }

    private static void registerTransactionStateObserver(Iterable<FanDBNodeInfo> targetDBNodes) {
        for (FanDBNodeInfo targetDBNode : targetDBNodes) {
            List<PGConnection> connections = targetDBNode.getConnections();
            if (connections == null || connections.isEmpty()) continue;
            for (PGConnection connection : connections) {
                QueryExecutor queryExecutor = connection.tacGetQueryExecutor();
                queryExecutor.setObserver(new ConnTracStateObserver(connection));
            }
        }
    }

    private static void unRegisterTransactionStateObserver(Iterable<FanDBNodeInfo> targetDBNodes) {
        for (FanDBNodeInfo targetDBNode : targetDBNodes) {
            List<PGConnection> connections = targetDBNode.getConnections();
            if (connections == null || connections.isEmpty()) continue;
            for (PGConnection connection : connections) {
                QueryExecutor queryExecutor = connection.tacGetQueryExecutor();
                queryExecutor.setObserver(null);
            }
        }
    }

    private static boolean isAllConnectionHasLock(Iterable<FanDBNodeInfo> targetDBNodes) {
        for (FanDBNodeInfo fanDBNodeInfo : targetDBNodes) {
            List<PGConnection> connections = fanDBNodeInfo.getConnections();
            if (connections == null || connections.isEmpty()) continue;
            for (PGConnection connection : connections) {
                if (connection.hasLock()) continue;
                return false;
            }
        }
        return true;
    }

    public void cleanup(String alterClusterId) {
        TacClusterInfo tacClusterInfo = this.tacClusterInfoMap.get(alterClusterId);
        if (tacClusterInfo == null) {
            return;
        }
        List<FanDBNodeInfo> targetDBNodes = tacClusterInfo.getMaintenanceNodes();
        for (FanDBNodeInfo targetDBNode : targetDBNodes) {
            targetDBNode.setIsInTacStatus(false);
        }
        this.tacClusterInfoMap.remove(alterClusterId);
    }

    public void startStopTac(String altClusterId) {
        TacClusterInfo tacClusterInfo = this.tacClusterInfoMap.get(altClusterId);
        if (tacClusterInfo == null) {
            LoggerUtil.warn(LOGGER, "No such tacClusterInfo : " + altClusterId);
            return;
        }
        tacClusterInfo.setIsTimeOut(true);
    }

    public boolean tacIsTimeOut(String altClusterId) {
        TacClusterInfo tacClusterInfo = this.tacClusterInfoMap.get(altClusterId);
        if (tacClusterInfo == null) {
            return true;
        }
        return tacClusterInfo.getIsTimeOut();
    }

    public TacReConnectActuator buildTacReConnectActuator(ALTContext context, String altClusterId) throws ALTException {
        List<TacReConnectInfo> tacReConnectInfoList;
        TacClusterInfo tacClusterInfo = this.tacClusterInfoMap.get(altClusterId);
        if (tacClusterInfo == null) {
            return new TacReConnectActuator(context, altClusterId, new ArrayList<TacReConnectInfo>());
        }
        List<FanDBNodeInfo> needReConnectNodes = tacClusterInfo.getMaintenanceNodes();
        ArrayList<PGConnection> pgConnections = new ArrayList<PGConnection>();
        for (FanDBNodeInfo fanDBNodeInfo : needReConnectNodes) {
            List<PGConnection> targetCons = fanDBNodeInfo.getConnections();
            pgConnections.addAll(targetCons);
        }
        TacBatchExecution<PGConnection, TacReConnectInfo> tacBatchExecution = new TacBatchExecution<PGConnection, TacReConnectInfo>(pgConnections, context.buildQueryGucFunction(altClusterId));
        try {
            tacReConnectInfoList = tacBatchExecution.execute(QUERY_INFO_TIMEOUT);
        }
        catch (ALTException e) {
            TacReConnectUtil.resetAndUnlockCons(pgConnections);
            throw new ALTException("timeout when build tacReconnectActuator, all connections convert to Normal Connection, the size of connection is " + pgConnections.size(), e.getCause());
        }
        LoggerUtil.debug(LOGGER, "Build tacReConnectActuator, the size of tacReConnectInfoList is " + tacReConnectInfoList.size());
        return new TacReConnectActuator(context, altClusterId, tacReConnectInfoList);
    }

    public boolean suspendOnInitConn(HostSpec hostSpec, Object suspendConn, String altClusterId) {
        if (altClusterId.isEmpty()) {
            return false;
        }
        TacClusterInfo tacClusterInfo = this.tacClusterInfoMap.get(altClusterId);
        if (tacClusterInfo == null) {
            tacClusterInfo = new TacClusterInfo();
        }
        ConcurrentHashMap<HostSpec, List<Object>> concurrentHashMap = tacClusterInfo.getSuspendThreads();
        List<Object> suspendThreads = concurrentHashMap.getOrDefault(hostSpec, Collections.synchronizedList(new LinkedList()));
        suspendThreads.add(suspendConn);
        concurrentHashMap.put(hostSpec, suspendThreads);
        tacClusterInfo.setSuspendThreads(concurrentHashMap);
        this.tacClusterInfoMap.put(altClusterId, tacClusterInfo);
        return true;
    }

    public void unlockSuspendConn(String altClusterId) {
        TacClusterInfo clusterInfo = this.tacClusterInfoMap.get(altClusterId);
        if (clusterInfo == null) {
            return;
        }
        ConcurrentHashMap<HostSpec, List<Object>> cluster = clusterInfo.getSuspendThreads();
        for (Map.Entry<HostSpec, List<Object>> entry : cluster.entrySet()) {
            List<Object> suspendThreads = entry.getValue();
            if (suspendThreads == null || suspendThreads.size() <= 0) continue;
            for (Object suspendThread : suspendThreads) {
                suspendThread.notifyAll();
            }
            entry.setValue(Collections.synchronizedList(new LinkedList()));
        }
        LoggerUtil.debug(LOGGER, "Tac:unlock Suspend Init Connection success");
    }

    public void cleanOldConnections(String altClusterId) {
        TacClusterInfo tacClusterInfo = this.tacClusterInfoMap.get(altClusterId);
        if (tacClusterInfo == null) {
            return;
        }
        List<FanDBNodeInfo> reConnectNodes = tacClusterInfo.getMaintenanceNodes();
        if (reConnectNodes == null || reConnectNodes.isEmpty()) {
            return;
        }
        for (FanDBNodeInfo fanDBNodeInfo : reConnectNodes) {
            fanDBNodeInfo.setConnections(Collections.synchronizedList(new LinkedList()));
        }
    }

    public boolean isInTacProcess(String altClusterId) {
        TacClusterInfo tacClusterInfo = this.tacClusterInfoMap.get(altClusterId);
        return tacClusterInfo != null;
    }

    public String toString() {
        return "TacTracker{, tacClusterInfoMap=" + this.tacClusterInfoMap + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TacTracker)) {
            return false;
        }
        TacTracker that = (TacTracker)o;
        return Objects.equals(this.tacClusterInfoMap, that.tacClusterInfoMap);
    }

    public int hashCode() {
        return Objects.hash(this.tacClusterInfoMap);
    }

    private static final class InstanceHolder {
        static final TacTracker INSTANCE = new TacTracker();

        private InstanceHolder() {
        }
    }
}

