/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gaussdb.jdbc.jdbc.alt.fan;

import com.huawei.gaussdb.jdbc.PGProperty;
import com.huawei.gaussdb.jdbc.jdbc.alt.enums.StartupParam;
import com.huawei.gaussdb.jdbc.jdbc.alt.util.ByteConvertUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import java.util.Properties;

public class GnsStartupPacket {
    private static final int GNS_START_UP_PACKET_LENGTH = 128;
    private static final int SP_USER_LENGTH = 32;
    private static final int SP_NODE_NAME_LENGTH = 64;
    private static final int SP_HOST_LENGTH = 16;
    String spUser;
    String spNodeName;
    String spHost;
    int nodeId;
    int spRemoteType;
    int spIsPostMaster;

    public GnsStartupPacket(Properties prop) {
        this.spUser = this.initParam(prop, PGProperty.USER.getName(), "");
        this.spNodeName = this.initParam(prop, PGProperty.PG_DBNAME.getName(), "");
        this.spHost = this.initParam(prop, StartupParam.SP_HOST.getKey(), "");
        this.nodeId = Integer.parseInt(this.initParam(prop, StartupParam.NODE_ID.getKey(), "0"));
        this.spRemoteType = Integer.parseInt(this.initParam(prop, StartupParam.SP_REMOTE_TYPE.getKey(), "6"));
        this.spIsPostMaster = this.initSSL(prop) != false ? 1 : 0;
    }

    public String getSpUser() {
        return this.spUser;
    }

    public void setSpUser(String spUser) {
        this.spUser = spUser;
    }

    public String getSpNodeName() {
        return this.spNodeName;
    }

    public void setSpNodeName(String spNodeName) {
        this.spNodeName = spNodeName;
    }

    public String getSpHost() {
        return this.spHost;
    }

    public void setSpHost(String spHost) {
        this.spHost = spHost;
    }

    public int getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(int nodeId) {
        this.nodeId = nodeId;
    }

    public int getSpRemoteType() {
        return this.spRemoteType;
    }

    public void setSpRemoteType(int spRemoteType) {
        this.spRemoteType = spRemoteType;
    }

    public int getSpIsPostMaster() {
        return this.spIsPostMaster;
    }

    public void setSpIsPostMaster(int spIsPostMaster) {
        this.spIsPostMaster = spIsPostMaster;
    }

    private String initParam(Properties prop, String key, String defaultValue) {
        return prop.containsKey(key) ? prop.getProperty(key) : defaultValue;
    }

    private Boolean initSSL(Properties prop) {
        return prop.containsKey(PGProperty.SSL.getName()) && PGProperty.SSL.getBoolean(prop);
    }

    public byte[] toBytes() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.serialize(bos);
        return bos.toByteArray();
    }

    private void serialize(ByteArrayOutputStream bos) throws IOException {
        bos.write(ByteConvertUtil.int4(128, true));
        bos.write(ByteConvertUtil.str(this.spUser, 32));
        bos.write(ByteConvertUtil.str(this.spNodeName, 64));
        bos.write(ByteConvertUtil.str(this.spHost, 16));
        bos.write(ByteConvertUtil.int4(this.nodeId, true));
        bos.write(ByteConvertUtil.int4(this.spRemoteType, true));
        bos.write(ByteConvertUtil.int4(this.spIsPostMaster, true));
    }

    public String toString() {
        return "GnsStartUpPacket{spUser='" + this.spUser + '\'' + ", spNodeName='" + this.spNodeName + '\'' + ", spHost='" + this.spHost + '\'' + ", nodeId=" + this.nodeId + ", spRemoteType=" + this.spRemoteType + ", spIsPostMaster=" + this.spIsPostMaster + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GnsStartupPacket)) {
            return false;
        }
        GnsStartupPacket that = (GnsStartupPacket)o;
        return this.nodeId == that.nodeId && this.spRemoteType == that.spRemoteType && this.spIsPostMaster == that.spIsPostMaster && Objects.equals(this.spUser, that.spUser) && Objects.equals(this.spNodeName, that.spNodeName) && Objects.equals(this.spHost, that.spHost);
    }

    public int hashCode() {
        return Objects.hash(this.spUser, this.spNodeName, this.spHost, this.nodeId, this.spRemoteType, this.spIsPostMaster);
    }
}

