/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gaussdb.jdbc.jdbc.alt.connection;

import com.huawei.gaussdb.jdbc.jdbc.alt.exception.ALTException;
import com.huawei.gaussdb.jdbc.jdbc.alt.tac.TacLock;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class GnsLockManager {
    private final Map<String, TacLock> tacLocks = new ConcurrentHashMap<String, TacLock>();

    private GnsLockManager() {
    }

    public static GnsLockManager getInstance() {
        return InstanceHolder.INSTANCE;
    }

    public synchronized TacLock register(String altClusterId) {
        TacLock tacLock = this.tacLocks.get(altClusterId);
        if (tacLock == null) {
            TacLock initTacLock = new TacLock();
            this.tacLocks.put(altClusterId, initTacLock);
            return initTacLock;
        }
        return tacLock;
    }

    public boolean waitOnLock(String altClusterId, long timeMillis) {
        TacLock tacLock = this.tacLocks.get(altClusterId);
        if (tacLock == null) {
            return false;
        }
        return tacLock.waitOnLock(timeMillis);
    }

    public void lock(String altClusterId) {
        TacLock tacLock = this.tacLocks.get(altClusterId);
        if (tacLock == null) {
            return;
        }
        tacLock.lock();
    }

    public void unlock(String altClusterId) throws ALTException {
        TacLock tacLock = this.tacLocks.get(altClusterId);
        if (tacLock == null) {
            return;
        }
        tacLock.unlock();
    }

    public boolean hasLock(String altClusterId) {
        TacLock tacLock = this.tacLocks.get(altClusterId);
        if (tacLock == null) {
            return false;
        }
        return tacLock.hasLock();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GnsLockManager)) {
            return false;
        }
        GnsLockManager that = (GnsLockManager)o;
        return Objects.equals(this.tacLocks, that.tacLocks);
    }

    public int hashCode() {
        return Objects.hash(this.tacLocks);
    }

    public String toString() {
        return "GnsLockManager{tacLocks=" + this.tacLocks + '}';
    }

    private static final class InstanceHolder {
        static final GnsLockManager INSTANCE = new GnsLockManager();

        private InstanceHolder() {
        }
    }
}

