/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gaussdb.jdbc.jdbc.alt.batch;

import com.huawei.gaussdb.jdbc.jdbc.alt.batch.Function;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;

public class TacBatchTask<E, T>
implements Runnable {
    private final List<E> elements;
    private final Function<E, T> function;
    private final List<T> results;
    private final CountDownLatch countDownLatch;

    public TacBatchTask(List<E> elements, Function<E, T> function, CountDownLatch countDownLatch) {
        this.elements = elements;
        this.function = function;
        this.results = new ArrayList<T>();
        this.countDownLatch = countDownLatch;
    }

    @Override
    public void run() {
        for (E element : this.elements) {
            T result = this.function.apply(element);
            this.results.add(result);
        }
        this.countDownLatch.countDown();
    }

    public List<T> getResults() {
        return this.results;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TacBatchTask that = (TacBatchTask)o;
        return Objects.equals(this.elements, that.elements) && Objects.equals(this.function, that.function) && Objects.equals(this.results, that.results) && Objects.equals(this.countDownLatch, that.countDownLatch);
    }

    public int hashCode() {
        return Objects.hash(this.elements, this.function, this.results, this.countDownLatch);
    }

    public String toString() {
        return "TacBatchTask{elements=" + this.elements + ", function=" + this.function + ", results=" + this.results + ", countDownLatch=" + this.countDownLatch + '}';
    }
}

