/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gaussdb.jdbc.hostchooser;

import com.huawei.gaussdb.jdbc.hostchooser.DomainResolveInfo;
import com.huawei.gaussdb.jdbc.hostchooser.GlobalDomainResolveTracker;
import com.huawei.gaussdb.jdbc.log.Log;
import com.huawei.gaussdb.jdbc.log.Logger;
import java.sql.SQLException;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class DomainResolveTask {
    private static Log LOGGER = Logger.getLogger(DomainResolveTask.class.getName());
    private static final String TASK_THREAD_NAME = "domainResolveTaskThread";
    private static final long INTERVAL_TIME = 1L;
    private static final long RUN_TIME_THRESHOLD = 60000L;
    private static volatile boolean isTaskStarted = false;
    private static ScheduledExecutorService domainResolveScheduledExecutorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, DomainResolveTask.TASK_THREAD_NAME);
            t.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread t, Throwable e) {
                    LOGGER.error("[DomainResolveTask] init domainResolveScheduledExecutorService threaddomainResolveTaskThread failed.", e);
                }
            });
            t.setDaemon(true);
            return t;
        }
    });

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void startTask() {
        if (isTaskStarted) return;
        Class<DomainResolveTask> clazz = DomainResolveTask.class;
        synchronized (DomainResolveTask.class) {
            if (isTaskStarted) return;
            domainResolveScheduledExecutorService.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    DomainResolveTask.run();
                }
            }, 1L, 1L, TimeUnit.SECONDS);
            isTaskStarted = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static void run() {
        Set<DomainResolveInfo> resolveInfos = GlobalDomainResolveTracker.getExpiredDomains();
        int success = 0;
        long startMillis = System.currentTimeMillis();
        for (DomainResolveInfo resolveInfo : resolveInfos) {
            try {
                GlobalDomainResolveTracker.refreshResolveInfo(resolveInfo);
                ++success;
            }
            catch (SQLException e) {
                LOGGER.error("[DomainResolveTask] resolve domain " + resolveInfo.getDomainName() + " failed.", e);
            }
        }
        long processMillis = System.currentTimeMillis() - startMillis;
        int total = resolveInfos.size();
        if (processMillis >= 60000L && LOGGER.isWarnEnabled()) {
            LOGGER.warn("[DomainResolveTask] resolve " + total + " domains " + success + " success, run time is " + processMillis + "ms.");
        }
        if (total > 0 && LOGGER.isTraceEnabled()) {
            LOGGER.trace("[DomainResolveTask] resolve " + total + " domains " + success + " success, run time is " + processMillis + "ms.");
        }
    }
}

